/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.bundles.IResourceBundle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptReferenceHeaderItem
extends JavaScriptHeaderItem
implements IReferenceHeaderItem {
    private final ResourceReference reference;
    private final String id;
    private final PageParameters pageParameters;
    private final boolean defer;
    private final String charset;

    public JavaScriptReferenceHeaderItem(ResourceReference reference, PageParameters pageParameters, String id, boolean defer, String charset, String condition) {
        super(condition);
        this.reference = reference;
        this.pageParameters = pageParameters;
        this.id = id;
        this.defer = defer;
        this.charset = charset;
    }

    @Override
    public ResourceReference getReference() {
        return this.reference;
    }

    public String getId() {
        return this.id;
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public boolean isDefer() {
        return this.defer;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        return this.getReference().getDependencies();
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        if (this.getReference() instanceof IResourceBundle) {
            return ((IResourceBundle)((Object)this.getReference())).getProvidedResources();
        }
        return super.getProvidedResources();
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, this.getUrl(), this.getId(), this.isDefer(), this.getCharset(), this.getCondition());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = Strings.stripJSessionId(this.getUrl());
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptReferenceHeaderItem(" + this.getUrl() + ")";
    }

    private String getUrl() {
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(this.getReference(), this.getPageParameters());
        return ((Object)RequestCycle.get().urlFor(handler)).toString();
    }

    public int hashCode() {
        return this.getReference().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaScriptReferenceHeaderItem) {
            return ((JavaScriptReferenceHeaderItem)obj).getReference().equals(this.getReference());
        }
        return false;
    }
}

