/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class JavaScriptContentHeaderItem
extends JavaScriptHeaderItem {
    private final CharSequence javaScript;
    private final String id;

    public JavaScriptContentHeaderItem(CharSequence javaScript, String id, String condition) {
        super(condition);
        this.javaScript = javaScript;
        this.id = id;
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty(this.getCondition());
        if (hasCondition) {
            response.write("<!--[if ");
            response.write(this.getCondition());
            response.write("]>");
        }
        JavaScriptUtils.writeJavaScript(response, this.getJavaScript(), this.getId());
        if (hasCondition) {
            response.write("<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList(this.getJavaScript());
        }
        return Arrays.asList(this.getId(), this.getJavaScript());
    }

    public String toString() {
        return "JavaScriptHeaderItem(" + this.getJavaScript() + ")";
    }

    public int hashCode() {
        return this.getJavaScript().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaScriptContentHeaderItem) {
            return ((JavaScriptContentHeaderItem)obj).getJavaScript().equals(this.getJavaScript());
        }
        return false;
    }
}

