/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class CssContentHeaderItem
extends CssHeaderItem {
    private final CharSequence css;
    private final String id;

    public CssContentHeaderItem(CharSequence css, String id, String condition) {
        super(condition);
        this.css = css;
        this.id = id;
    }

    public CharSequence getCss() {
        return this.css;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void render(Response response) {
        boolean hasCondition;
        boolean bl = hasCondition = !Strings.isEmpty(this.getCondition());
        if (hasCondition) {
            response.write("<!--[if ");
            response.write(this.getCondition());
            response.write("]>");
        }
        CssUtils.writeCss(response, this.getCss(), this.getId());
        if (hasCondition) {
            response.write("<![endif]-->\n");
        }
    }

    @Override
    public Iterable<?> getRenderTokens() {
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList(this.getCss());
        }
        return Arrays.asList(this.getId(), this.getCss());
    }

    public String toString() {
        return "CSSHeaderItem(" + this.getCss() + ")";
    }

    public int hashCode() {
        return this.getCss().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssContentHeaderItem) {
            return ((CssContentHeaderItem)obj).getCss().equals(this.getCss());
        }
        return false;
    }
}

