/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.DefaultMarkupResourceStreamProvider;
import org.apache.wicket.markup.IMarkupCache;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupCache;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupNotFoundException;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.loader.DefaultMarkupLoader;
import org.apache.wicket.markup.loader.IMarkupLoader;
import org.apache.wicket.markup.parser.IMarkupFilter;
import org.apache.wicket.markup.parser.IXmlPullParser;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupFactory {
    private static final Logger log = LoggerFactory.getLogger(MarkupFactory.class);
    private IMarkupCache markupCache;
    private IMarkupResourceStreamProvider markupResourceStreamProvider;

    public static final MarkupFactory get() {
        return Application.get().getMarkupSettings().getMarkupFactory();
    }

    public IMarkupLoader getMarkupLoader() {
        return new DefaultMarkupLoader();
    }

    public MarkupParser newMarkupParser(MarkupResourceStream resource) {
        return new MarkupParser(this.newXmlPullParser(), resource){

            @Override
            protected IMarkupFilter onAppendMarkupFilter(IMarkupFilter filter) {
                return MarkupFactory.this.onAppendMarkupFilter(filter);
            }
        };
    }

    protected IXmlPullParser newXmlPullParser() {
        return new XmlPullParser();
    }

    protected IMarkupFilter onAppendMarkupFilter(IMarkupFilter filter) {
        return filter;
    }

    public IMarkupCache getMarkupCache() {
        if (this.markupCache == null) {
            this.markupCache = new MarkupCache();
        }
        return this.markupCache;
    }

    public boolean hasMarkupCache() {
        return this.markupCache != null;
    }

    public final Markup getMarkup(MarkupContainer container, boolean enforceReload) {
        return this.getMarkup(container, container.getClass(), enforceReload);
    }

    public final Markup getMarkup(MarkupContainer container, Class<?> clazz, boolean enforceReload) {
        Args.notNull(container, "container");
        if (!this.checkMarkupType(container)) {
            return null;
        }
        Class<?> containerClass = this.getContainerClass(container, clazz);
        IMarkupCache cache = this.getMarkupCache();
        if (cache != null) {
            return cache.getMarkup(container, containerClass, enforceReload);
        }
        MarkupResourceStream markupResourceStream = this.getMarkupResourceStream(container, containerClass);
        return this.loadMarkup(container, markupResourceStream, enforceReload);
    }

    protected final boolean checkMarkupType(MarkupContainer container) {
        if (container.getMarkupType() == null) {
            if (log.isDebugEnabled()) {
                log.debug("Markup file not loaded, since the markup type is not yet available: " + container.toString());
            }
            return false;
        }
        return true;
    }

    protected final IMarkupResourceStreamProvider getMarkupResourceStreamProvider(MarkupContainer container) {
        if (container instanceof IMarkupResourceStreamProvider) {
            return (IMarkupResourceStreamProvider)((Object)container);
        }
        if (this.markupResourceStreamProvider == null) {
            this.markupResourceStreamProvider = new DefaultMarkupResourceStreamProvider();
        }
        return this.markupResourceStreamProvider;
    }

    public final MarkupResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> clazz) {
        Args.notNull(container, "container");
        if (!this.checkMarkupType(container)) {
            return null;
        }
        Class<?> containerClass = this.getContainerClass(container, clazz);
        IResourceStream resourceStream = this.getMarkupResourceStreamProvider(container).getMarkupResourceStream(container, containerClass);
        if (resourceStream == null) {
            return null;
        }
        if (resourceStream instanceof MarkupResourceStream) {
            return (MarkupResourceStream)resourceStream;
        }
        return new MarkupResourceStream(resourceStream, new ContainerInfo(container), containerClass);
    }

    public final Class<?> getContainerClass(MarkupContainer container, Class<?> clazz) {
        Args.notNull(container, "container");
        Class<?> containerClass = clazz;
        if (clazz == null) {
            containerClass = container.getClass();
        } else if (!clazz.isAssignableFrom(container.getClass())) {
            throw new IllegalArgumentException("Parameter clazz must be an instance of " + container.getClass().getName() + ", but is a " + clazz.getName());
        }
        return containerClass;
    }

    public final Markup loadMarkup(MarkupContainer container, MarkupResourceStream markupResourceStream, boolean enforceReload) {
        Args.notNull(container, "container");
        Args.notNull(markupResourceStream, "markupResourceStream");
        if (!this.checkMarkupType(container)) {
            return null;
        }
        try {
            return this.getMarkupLoader().loadMarkup(container, markupResourceStream, null, enforceReload);
        }
        catch (MarkupNotFoundException e) {
            log.error("Markup not found: " + e.getMessage(), (Throwable)e);
        }
        catch (ResourceStreamNotFoundException e) {
            log.error("Markup not found: " + markupResourceStream, (Throwable)e);
        }
        catch (IOException e) {
            log.error("Error while reading the markup " + markupResourceStream, (Throwable)e);
            throw new MarkupException(markupResourceStream, "IO error while reading markup: " + e.getMessage(), (Throwable)e);
        }
        catch (WicketRuntimeException e) {
            log.error("Error while reading the markup " + markupResourceStream, (Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            log.error("Error while reading the markup " + markupResourceStream, (Throwable)e);
            throw new MarkupException(markupResourceStream, "Error while reading the markup: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

