/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string.interpolator;

import org.apache.wicket.Application;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.Session;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.interpolator.VariableInterpolator;

public final class PropertyVariableInterpolator
extends VariableInterpolator
implements IConverterLocator {
    private static final long serialVersionUID = 1L;
    private final Object model;

    private PropertyVariableInterpolator(String string, Object model) {
        super(string);
        this.model = model;
    }

    public static String interpolate(String string, Object object) {
        if (string.contains("${")) {
            return new PropertyVariableInterpolator(string, object).toString();
        }
        return string;
    }

    @Override
    protected String getValue(String variableName) {
        Object value = PropertyResolver.getValue(variableName, this.model);
        if (value != null) {
            IConverter<?> converter = this.getConverter(value.getClass());
            if (converter != null) {
                return converter.convertToString(value, Session.get().getLocale());
            }
            return value.toString();
        }
        return null;
    }

    @Override
    public <C> IConverter<C> getConverter(Class<C> type) {
        if (Application.exists()) {
            return Application.get().getConverterLocator().getConverter(type);
        }
        return null;
    }
}

