/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUtils {
    public static final String SCRIPT_OPEN_TAG = "<script type=\"text/javascript\">\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CLOSE_TAG = "\n/*]]>*/\n</script>\n";
    public static final String SCRIPT_CONTENT_PREFIX = "\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CONTENT_SUFFIX = "\n/*]]>*/\n";
    private final Response response;

    public JavaScriptUtils(Response response, String id) {
        this.response = response;
        JavaScriptUtils.writeOpenTag(response, id);
    }

    public JavaScriptUtils(Response response) {
        this.response = response;
        JavaScriptUtils.writeOpenTag(response);
    }

    public static CharSequence escapeQuotes(CharSequence input) {
        CharSequence s = input;
        if (s != null) {
            s = Strings.replaceAll(s, "'", "\\'");
            s = Strings.replaceAll(s, "\"", "\\\"");
        }
        return s;
    }

    public static void writeJavaScriptUrl(Response response, CharSequence url, String id) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, id, false, null);
    }

    public static void writeJavaScriptUrl(Response response, CharSequence url, String id, boolean defer, String charset) {
        response.write("<script type=\"text/javascript\" ");
        if (id != null) {
            response.write("id=\"" + id + "\" ");
        }
        if (defer) {
            response.write("defer=\"defer\" ");
        }
        if (charset != null) {
            response.write("charset=\"" + charset + "\" ");
        }
        response.write("src=\"");
        response.write(url);
        response.write("\"></script>");
        response.write("\n");
    }

    public static void writeJavaScriptUrl(Response response, CharSequence url) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, null);
    }

    public static void writeJavaScript(Response response, CharSequence text, String id) {
        JavaScriptUtils.writeOpenTag(response, id);
        response.write(text);
        JavaScriptUtils.writeCloseTag(response);
    }

    public static void writeJavaScript(Response response, CharSequence text) {
        JavaScriptUtils.writeJavaScript(response, text, null);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write("<script type=\"text/javascript\" ");
        if (id != null) {
            response.write("id=\"" + id + "\"");
        }
        response.write(">");
        response.write(SCRIPT_CONTENT_PREFIX);
    }

    public static void writeOpenTag(Response response) {
        JavaScriptUtils.writeOpenTag(response, null);
    }

    public static void writeCloseTag(Response response) {
        response.write(SCRIPT_CONTENT_SUFFIX);
        response.write("</script>\n");
    }

    public void write(CharSequence script) {
        this.response.write(script);
    }

    public void println(CharSequence script) {
        this.response.write(script);
    }

    public void close() {
        JavaScriptUtils.writeCloseTag(this.response);
    }
}

