/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.string;

import org.apache.wicket.request.Response;

public final class CssUtils {
    public static final String INLINE_OPEN_TAG = "<style type=\"text/css\"><!--\n";
    public static final String INLINE_CLOSE_TAG = "--></style>\n";

    private CssUtils() {
    }

    public static void writeCss(Response response, CharSequence text, String id) {
        CssUtils.writeOpenTag(response, id);
        response.write(text);
        CssUtils.writeCloseTag(response);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write("<style type=\"text/css\" ");
        if (id != null) {
            response.write("id=\"" + id + "\"");
        }
        response.write("><!--\n");
    }

    public static void writeCloseTag(Response response) {
        response.write(INLINE_CLOSE_TAG);
    }
}

