/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.resource.locator;

import java.util.Iterator;
import java.util.Locale;
import org.apache.wicket.util.string.Strings;

public class LocaleResourceNameIterator
implements Iterator<String> {
    private final Locale locale;
    private int state = 0;
    private final boolean strict;

    public LocaleResourceNameIterator(Locale locale, boolean strict) {
        this.locale = locale;
        this.strict = strict;
    }

    public Locale getLocale() {
        if (this.state == 1) {
            return this.locale;
        }
        if (this.state == 2) {
            return new Locale(this.locale.getLanguage(), this.locale.getCountry());
        }
        if (this.state == 3) {
            return new Locale(this.locale.getLanguage());
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        int limit = 4;
        if (this.strict && this.locale != null) {
            limit = 3;
        }
        return this.state < limit;
    }

    @Override
    public String next() {
        if (this.locale == null) {
            this.state = 999;
            return "";
        }
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        String variant = this.locale.getVariant();
        if (this.state == 0) {
            ++this.state;
            if (!Strings.isEmpty(variant)) {
                return '_' + language + '_' + country + '_' + variant;
            }
        }
        if (this.state == 1) {
            ++this.state;
            if (!Strings.isEmpty(country)) {
                return '_' + language + '_' + country;
            }
        }
        if (this.state == 2) {
            ++this.state;
            if (!Strings.isEmpty(language)) {
                return '_' + language;
            }
        }
        ++this.state;
        return "";
    }

    @Override
    public void remove() {
    }
}

