/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.file;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.util.file.Folder;
import org.apache.wicket.util.file.Path;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebApplicationPath
extends Path {
    private static final Logger log = LoggerFactory.getLogger(WebApplicationPath.class);
    private static final String WEB_INF = "WEB-INF/";
    private final List<String> webappPaths = new ArrayList<String>();
    private final ServletContext servletContext;

    public WebApplicationPath(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.webappPaths.add("/");
    }

    @Override
    public void add(String path) {
        Folder folder = new Folder(path);
        if (folder.exists()) {
            log.debug("Added path '{}' as a folder.", (Object)path);
            super.add(folder);
        } else {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            log.debug("Added path '{}' as a web path.", (Object)path);
            this.webappPaths.add(path);
        }
    }

    @Override
    public IResourceStream find(Class<?> clazz, String pathname) {
        if (pathname == null) {
            return null;
        }
        IResourceStream resourceStream = super.find(clazz, pathname);
        if (resourceStream == null && !pathname.startsWith(WEB_INF)) {
            for (String path : this.webappPaths) {
                try {
                    URL url = this.servletContext.getResource(path + pathname);
                    if (url == null) continue;
                    resourceStream = new UrlResourceStream(url);
                    break;
                }
                catch (Exception ex) {
                }
            }
        }
        return resourceStream;
    }

    public List<String> getWebappPaths() {
        return this.webappPaths;
    }

    @Override
    public String toString() {
        return "[folders = " + StringList.valueOf(this.getFolders()) + ", webapppaths: " + StringList.valueOf(this.webappPaths) + "]";
    }
}

