/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class ResourceMapper
extends AbstractMapper
implements IRequestMapper {
    private final IPageParametersEncoder parametersEncoder;
    private final String[] mountSegments;
    private final ResourceReference resourceReference;

    public ResourceMapper(String path, ResourceReference resourceReference) {
        this(path, resourceReference, new PageParametersEncoder());
    }

    public ResourceMapper(String path, ResourceReference resourceReference, IPageParametersEncoder encoder) {
        Args.notEmpty(path, "path");
        Args.notNull(resourceReference, "resourceReference");
        Args.notNull(encoder, "encoder");
        this.resourceReference = resourceReference;
        this.mountSegments = this.getMountSegments(path);
        this.parametersEncoder = encoder;
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        Url url = new Url(request.getUrl());
        PageParameters parameters = this.extractPageParameters(request, this.mountSegments.length, this.parametersEncoder);
        this.removeCachingDecoration(url, parameters);
        if (!this.urlStartsWith(url, this.mountSegments)) {
            return null;
        }
        for (int index = 0; index < this.mountSegments.length; ++index) {
            String placeholder = this.getPlaceholder(this.mountSegments[index]);
            if (placeholder == null) continue;
            if (parameters == null) {
                parameters = new PageParameters();
            }
            parameters.add(placeholder, url.getSegments().get(index));
        }
        return new ResourceReferenceRequestHandler(this.resourceReference, parameters);
    }

    @Override
    public int getCompatibilityScore(Request request) {
        return 0;
    }

    @Override
    public Url mapHandler(IRequestHandler requestHandler) {
        if (!(requestHandler instanceof ResourceReferenceRequestHandler)) {
            return null;
        }
        ResourceReferenceRequestHandler handler = (ResourceReferenceRequestHandler)requestHandler;
        if (!this.resourceReference.equals(handler.getResourceReference())) {
            return null;
        }
        Url url = new Url();
        for (String segment : this.mountSegments) {
            url.getSegments().add(segment);
        }
        PageParameters parameters = new PageParameters(handler.getPageParameters());
        for (int index = 0; index < this.mountSegments.length; ++index) {
            String placeholder = this.getPlaceholder(this.mountSegments[index]);
            if (placeholder == null) continue;
            url.getSegments().set(index, parameters.get(placeholder).toString(""));
            parameters.remove(placeholder, new String[0]);
        }
        this.addCachingDecoration(url, parameters);
        return this.encodePageParameters(url, parameters, this.parametersEncoder);
    }

    protected IResourceCachingStrategy getCachingStrategy() {
        return Application.get().getResourceSettings().getCachingStrategy();
    }

    protected void addCachingDecoration(Url url, PageParameters parameters) {
        IResource resource;
        int lastSegmentAt;
        List<String> segments = url.getSegments();
        String filename = segments.get(lastSegmentAt = segments.size() - 1);
        if (!Strings.isEmpty(filename) && (resource = this.resourceReference.getResource()) instanceof IStaticCacheableResource) {
            IStaticCacheableResource cacheable = (IStaticCacheableResource)resource;
            ResourceUrl cacheUrl = new ResourceUrl(filename, parameters);
            this.getCachingStrategy().decorateUrl(cacheUrl, cacheable);
            if (Strings.isEmpty(cacheUrl.getFileName())) {
                throw new IllegalStateException("caching strategy returned empty name for " + resource);
            }
            segments.set(lastSegmentAt, cacheUrl.getFileName());
        }
    }

    protected void removeCachingDecoration(Url url, PageParameters parameters) {
        List<String> segments = url.getSegments();
        if (!segments.isEmpty()) {
            int lastSegmentAt = segments.size() - 1;
            String filename = segments.get(lastSegmentAt);
            if (Strings.isEmpty(filename)) {
                return;
            }
            ResourceUrl resourceUrl = new ResourceUrl(filename, parameters);
            this.getCachingStrategy().undecorateUrl(resourceUrl);
            if (Strings.isEmpty(resourceUrl.getFileName())) {
                throw new IllegalStateException("caching strategy returned empty name for " + resourceUrl);
            }
            segments.set(lastSegmentAt, resourceUrl.getFileName());
        }
    }
}

