/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import java.lang.reflect.Modifier;
import org.apache.wicket.core.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.PackageName;

public class PackageMapper
extends AbstractBookmarkableMapper {
    private final PackageName packageName;
    private final IPageParametersEncoder pageParametersEncoder;

    public PackageMapper(PackageName packageName) {
        this(packageName, new PageParametersEncoder());
    }

    public PackageMapper(PackageName packageName, IPageParametersEncoder pageParametersEncoder) {
        Args.notNull(packageName, "packageName");
        Args.notNull(pageParametersEncoder, "pageParametersEncoder");
        this.packageName = packageName;
        this.pageParametersEncoder = pageParametersEncoder;
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Class<? extends IRequestablePage> pageClass = info.getPageClass();
        PackageName pageClassPackageName = PackageName.forClass(pageClass);
        if (pageClassPackageName.equals(this.packageName)) {
            String fullyQualifiedClassName;
            Url url = new Url();
            String packageRelativeClassName = fullyQualifiedClassName = pageClass.getName();
            int packageNameLength = this.packageName.getName().length();
            if (packageNameLength > 0) {
                packageRelativeClassName = fullyQualifiedClassName.substring(packageNameLength + 1);
            }
            packageRelativeClassName = this.transformForUrl(packageRelativeClassName);
            url.getSegments().add(packageRelativeClassName);
            this.encodePageComponentInfo(url, info.getPageComponentInfo());
            return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
        }
        return null;
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        Url url = request.getUrl();
        if (url.getSegments().size() >= 1) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            String className = url.getSegments().get(0);
            if (!this.isValidClassName(className)) {
                return null;
            }
            className = this.transformFromUrl(className);
            String fullyQualifiedClassName = this.packageName.getName() + '.' + className;
            Class<? extends IRequestablePage> pageClass = this.getPageClass(fullyQualifiedClassName);
            if (pageClass != null && !Modifier.isAbstract(pageClass.getModifiers()) && IRequestablePage.class.isAssignableFrom(pageClass)) {
                PageParameters pageParameters = this.extractPageParameters(request, 1, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    private boolean isValidClassName(String className) {
        if (className == null) {
            return false;
        }
        return !className.startsWith(".");
    }

    protected String transformFromUrl(String classNameAlias) {
        return classNameAlias;
    }

    protected String transformForUrl(String className) {
        return className;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        return 0;
    }
}

