/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.mapper;

import org.apache.wicket.Application;
import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.core.request.mapper.IMapperContext;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractComponentMapper
extends AbstractMapper
implements IRequestMapper {
    protected IMapperContext getContext() {
        return Application.get().getMapperContext();
    }

    protected String requestListenerInterfaceToString(RequestListenerInterface listenerInterface) {
        Args.notNull(listenerInterface, "listenerInterface");
        return this.getContext().requestListenerInterfaceToString(listenerInterface);
    }

    protected RequestListenerInterface requestListenerInterfaceFromString(String interfaceName) {
        Args.notEmpty(interfaceName, "interfaceName");
        return this.getContext().requestListenerInterfaceFromString(interfaceName);
    }

    protected PageComponentInfo getPageComponentInfo(Url url) {
        if (url == null) {
            throw new IllegalStateException("Argument 'url' may not be null.");
        }
        for (Url.QueryParameter queryParameter : url.getQueryParameters()) {
            PageComponentInfo pageComponentInfo;
            if (!Strings.isEmpty(queryParameter.getValue()) || (pageComponentInfo = PageComponentInfo.parse(queryParameter.getName())) == null) continue;
            return pageComponentInfo;
        }
        return null;
    }

    protected void encodePageComponentInfo(Url url, PageComponentInfo info) {
        String s;
        Args.notNull(url, "url");
        if (info != null && !Strings.isEmpty(s = info.toString())) {
            Url.QueryParameter parameter = new Url.QueryParameter(s, "");
            url.getQueryParameters().add(parameter);
        }
    }

    protected Class<? extends IRequestablePage> getPageClass(String name) {
        Args.notEmpty(name, "name");
        return WicketObjects.resolveClass(name);
    }

    @Override
    protected void removeMetaParameter(Url urlCopy) {
        String pageComponentInfoCandidate = urlCopy.getQueryParameters().get(0).getName();
        if (PageComponentInfo.parse(pageComponentInfoCandidate) != null) {
            urlCopy.getQueryParameters().remove(0);
        }
    }
}

