/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.Page;
import org.apache.wicket.core.request.handler.ComponentNotFoundException;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

public class PageAndComponentProvider
extends PageProvider
implements IPageAndComponentProvider {
    private IRequestableComponent component;
    private String componentPath;

    public PageAndComponentProvider(IRequestablePage page, String componentPath) {
        super(page);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(IRequestablePage page, IRequestableComponent component) {
        super(page);
        Args.notNull(component, "component");
        this.component = component;
    }

    public PageAndComponentProvider(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, String componentPath) {
        super(pageClass, pageParameters);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(Class<? extends IRequestablePage> pageClass, String componentPath) {
        super(pageClass);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(int pageId, Class<? extends IRequestablePage> pageClass, Integer renderCount, String componentPath) {
        super(pageId, pageClass, renderCount);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(int pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount, String componentPath) {
        super(pageId, pageClass, pageParameters, renderCount);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(int pageId, Integer renderCount, String componentPath) {
        super(pageId, renderCount);
        this.setComponentPath(componentPath);
    }

    public PageAndComponentProvider(IRequestablePage page, IRequestableComponent component, PageParameters parameters) {
        super(page);
        Args.notNull(component, "component");
        this.component = component;
        if (parameters != null) {
            this.setPageParameters(parameters);
        }
    }

    @Override
    public IRequestableComponent getComponent() {
        if (this.component == null) {
            IRequestablePage page = this.getPageInstance();
            this.component = page.get(this.componentPath);
            if (this.component == null && page.isPageStateless()) {
                Page p = (Page)page;
                p.internalInitialize();
                p.internalPrepareForRender(false);
                this.component = page.get(this.componentPath);
            }
        }
        if (this.component == null) {
            throw new ComponentNotFoundException("Could not find component '" + this.componentPath + "' on page '" + this.getPageClass());
        }
        return this.component;
    }

    @Override
    public String getComponentPath() {
        if (this.componentPath != null) {
            return this.componentPath;
        }
        return this.component.getPageRelativePath();
    }

    private void setComponentPath(String componentPath) {
        Args.notNull(componentPath, "componentPath");
        this.componentPath = componentPath;
    }
}

