/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.request.handler;

import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.core.request.handler.IComponentRequestHandler;
import org.apache.wicket.core.request.handler.IPageAndComponentProvider;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.core.request.handler.PageAndComponentProvider;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkableListenerInterfaceRequestHandler
implements IPageRequestHandler,
IComponentRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(BookmarkableListenerInterfaceRequestHandler.class);
    private final IPageAndComponentProvider pageComponentProvider;
    private final RequestListenerInterface listenerInterface;
    private final Integer behaviorIndex;

    public BookmarkableListenerInterfaceRequestHandler(IPageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface, Integer behaviorIndex) {
        Args.notNull(pageComponentProvider, "pageComponentProvider");
        Args.notNull(listenerInterface, "listenerInterface");
        this.pageComponentProvider = pageComponentProvider;
        this.listenerInterface = listenerInterface;
        this.behaviorIndex = behaviorIndex;
    }

    public BookmarkableListenerInterfaceRequestHandler(PageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface) {
        this(pageComponentProvider, listenerInterface, null);
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.pageComponentProvider.getComponent();
    }

    @Override
    public final String getComponentPath() {
        return this.pageComponentProvider.getComponentPath();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageComponentProvider.getPageInstance();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageComponentProvider.getPageClass();
    }

    @Override
    public Integer getPageId() {
        return this.pageComponentProvider.getPageId();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageComponentProvider.getPageParameters();
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
        this.pageComponentProvider.detach();
    }

    public RequestListenerInterface getListenerInterface() {
        return this.listenerInterface;
    }

    public Integer getBehaviorIndex() {
        return this.behaviorIndex;
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
    }

    @Override
    public final boolean isPageInstanceCreated() {
        return true;
    }

    @Override
    public final Integer getRenderCount() {
        return this.pageComponentProvider.getRenderCount();
    }
}

