/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authorization.strategies.action.IActionAuthorizer;
import org.apache.wicket.request.component.IRequestableComponent;

public class ActionAuthorizationStrategy
implements IAuthorizationStrategy {
    private final Map<Action, IActionAuthorizer> actionAuthorizerForAction = new HashMap<Action, IActionAuthorizer>();

    public void addActionAuthorizer(IActionAuthorizer authorizer) {
        this.actionAuthorizerForAction.put(authorizer.getAction(), authorizer);
    }

    @Override
    public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        return true;
    }

    @Override
    public boolean isActionAuthorized(Component component, Action action) {
        IActionAuthorizer authorizer = this.actionAuthorizerForAction.get(action);
        if (authorizer != null) {
            return authorizer.authorizeAction(component);
        }
        return false;
    }
}

