/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html.form;

import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.form.AjaxFormSubmitBehavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;

public abstract class AjaxFallbackButton
extends Button {
    private static final long serialVersionUID = 1L;
    private final Form<?> mForm;

    public AjaxFallbackButton(String id, Form<?> form) {
        this(id, null, form);
    }

    public AjaxFallbackButton(String id, IModel<String> model, Form<?> form) {
        super(id, model);
        this.mForm = form;
        this.add(new AjaxFormSubmitBehavior(form, "click"){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onSubmit(target, AjaxFallbackButton.this.getForm());
            }

            @Override
            protected void onError(AjaxRequestTarget target) {
                AjaxFallbackButton.this.onError(target, AjaxFallbackButton.this.getForm());
            }

            @Override
            protected AjaxChannel getChannel() {
                return AjaxFallbackButton.this.getChannel();
            }

            @Override
            public boolean getDefaultProcessing() {
                return AjaxFallbackButton.this.getDefaultFormProcessing();
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxFallbackButton.this.updateAjaxAttributes(attributes);
            }
        });
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    protected abstract void onError(AjaxRequestTarget var1, Form<?> var2);

    @Override
    public final void onSubmit() {
        if (this.getRequestCycle().find(AjaxRequestTarget.class) == null) {
            this.onSubmit(null, this.getForm());
        }
    }

    @Override
    public Form<?> getForm() {
        return this.mForm == null ? super.getForm() : this.mForm;
    }

    protected abstract void onSubmit(AjaxRequestTarget var1, Form<?> var2);

    @Deprecated
    protected AjaxChannel getChannel() {
        return null;
    }

    protected final boolean isButtonEnabled() {
        return this.isEnabledInHierarchy();
    }
}

