/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.markup.html;

import org.apache.wicket.ajax.AjaxChannel;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.IAjaxLink;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;

public abstract class AjaxLink<T>
extends AbstractLink
implements IAjaxLink {
    private static final long serialVersionUID = 1L;

    public AjaxLink(String id) {
        this(id, (IModel<T>)null);
    }

    public AjaxLink(String id, IModel<T> model) {
        super(id, model);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.add(this.newAjaxEventBehavior("onclick"));
    }

    protected AjaxEventBehavior newAjaxEventBehavior(String event) {
        return new AjaxEventBehavior(event){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                AjaxLink.this.onClick(target);
            }

            @Override
            protected void onComponentTag(ComponentTag tag) {
                if (AjaxLink.this.isLinkEnabled()) {
                    super.onComponentTag(tag);
                }
            }

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                AjaxLink.this.updateAjaxAttributes(attributes);
            }
        };
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
    }

    @Deprecated
    protected AjaxChannel getChannel() {
        return null;
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        if (this.isLinkEnabled()) {
            if (tag.getName().equalsIgnoreCase("a") || tag.getName().equalsIgnoreCase("link") || tag.getName().equalsIgnoreCase("area")) {
                tag.put("href", "#");
            }
        } else {
            this.disableLink(tag);
        }
    }

    @Override
    public abstract void onClick(AjaxRequestTarget var1);

    public final IModel<T> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<T> model) {
        this.setDefaultModel((IModel)model);
    }

    public final T getModelObject() {
        return (T)this.getDefaultModelObject();
    }

    public final void setModelObject(T object) {
        this.setDefaultModelObject(object);
    }
}

