/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax.form;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.util.string.AppendingStringBuffer;

public abstract class AjaxFormChoiceComponentUpdatingBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        AppendingStringBuffer asb = new AppendingStringBuffer();
        asb.append("function attachChoiceHandlers(markupId, attrs) {\n");
        asb.append(" function getInputValues(groupId) {\n");
        asb.append("  var result = [];\n");
        asb.append("  var inputNodes = Wicket.$(groupId).getElementsByTagName('input');\n");
        asb.append("  for (var i = 0 ; i < inputNodes.length ; i ++) {\n");
        asb.append("   var inputNode = inputNodes[i];\n");
        asb.append("   if (!inputNode.checked) continue;\n");
        asb.append("   if (!inputNode.type) continue;\n");
        asb.append("   if (!(inputNode.className.indexOf('wicket-'+markupId)>=0)&&!(inputNode.id.indexOf(markupId+'-')>=0)) continue;\n");
        asb.append("   var inputType = inputNode.type.toLowerCase();\n");
        asb.append("   if (inputType === 'checkbox' || inputType === 'radio') {\n");
        asb.append("    var name = inputNode.name, value = inputNode.value;\n");
        asb.append("    result.push({ name: name, value: value });\n");
        asb.append("   }\n");
        asb.append("  }\n");
        asb.append("  return result;\n");
        asb.append(" }\n");
        asb.append(" attrs.dep = [ function() { var deps = getInputValues(markupId); return deps; } ];\n");
        asb.append(" Wicket.Ajax.post(attrs);\n");
        asb.append("}\n");
        response.render(JavaScriptHeaderItem.forScript(asb, "attachChoice-" + component.getMarkupId()));
        String onLoadScript = String.format("attachChoiceHandlers('%s', %s)", component.getMarkupId(), this.renderAjaxAttributes(component));
        response.render(OnLoadHeaderItem.forScript(onLoadScript));
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setEventNames("click");
        attributes.setAllowDefault(true);
    }

    protected abstract void onUpdate(AjaxRequestTarget var1);

    protected void onError(AjaxRequestTarget target, RuntimeException e) {
        if (e != null) {
            throw e;
        }
    }

    @Override
    protected void onBind() {
        super.onBind();
        if (!AjaxFormChoiceComponentUpdatingBehavior.appliesTo(this.getComponent())) {
            throw new WicketRuntimeException("Behavior " + this.getClass().getName() + " can only be added to an instance of a RadioChoice/CheckboxChoice/RadioGroup/CheckGroup");
        }
        if (this.getComponent() instanceof RadioGroup || this.getComponent() instanceof CheckGroup) {
            this.getComponent().setRenderBodyOnly(false);
        }
    }

    protected final FormComponent<?> getFormComponent() {
        return (FormComponent)this.getComponent();
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        FormComponent<?> formComponent = this.getFormComponent();
        try {
            formComponent.inputChanged();
            formComponent.validate();
            if (formComponent.hasErrorMessage()) {
                formComponent.invalid();
                this.onError(target, null);
            } else {
                formComponent.valid();
                formComponent.updateModel();
                this.onUpdate(target);
            }
        }
        catch (RuntimeException e) {
            this.onError(target, e);
        }
    }

    static boolean appliesTo(Component component) {
        return component instanceof RadioChoice || component instanceof CheckBoxMultipleChoice || component instanceof RadioGroup || component instanceof CheckGroup;
    }
}

