/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.util.lang.Args;

public abstract class AjaxEventBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final String event;

    public AjaxEventBehavior(String event) {
        Args.notEmpty(event, "event");
        this.onCheckEvent(event);
        event = event.toLowerCase();
        if (event.startsWith("on")) {
            event = event.substring(2);
        }
        this.event = event;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (component.isEnabledInHierarchy()) {
            CharSequence js = this.getCallbackScript(component);
            AjaxRequestTarget target = component.getRequestCycle().find(AjaxRequestTarget.class);
            if (target == null) {
                response.render(OnDomReadyHeaderItem.forScript(((Object)js).toString()));
            } else {
                target.appendJavaScript(js);
            }
        }
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.setEventNames(this.event);
    }

    protected void onCheckEvent(String event) {
    }

    public final String getEvent() {
        return this.event;
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected abstract void onEvent(AjaxRequestTarget var1);
}

