/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;

public class AjaxChannel
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Type type;

    public AjaxChannel(String name) {
        this(name, Type.QUEUE);
    }

    public AjaxChannel(String name, Type type) {
        this.name = Args.notNull(name, "name");
        this.type = Args.notNull(type, "type");
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    String getChannelName() {
        return this.toString();
    }

    public String toString() {
        return String.format("%s|%s", this.name, this.type == Type.QUEUE ? "s" : "d");
    }

    public static enum Type {
        QUEUE,
        DROP;

    }
}

