/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.time.Duration;

public abstract class AbstractAjaxTimerBehavior
extends AbstractDefaultAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private Duration updateInterval;
    private boolean stopped = false;
    private boolean headRendered = false;

    public AbstractAjaxTimerBehavior(Duration updateInterval) {
        this.setUpdateInterval(updateInterval);
    }

    protected final void setUpdateInterval(Duration updateInterval) {
        if (updateInterval == null || updateInterval.getMilliseconds() <= 0L) {
            throw new IllegalArgumentException("Invalid update interval");
        }
        this.updateInterval = updateInterval;
    }

    public final Duration getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        WebRequest request = (WebRequest)component.getRequest();
        if (!(this.isStopped() || this.headRendered && request.isAjax())) {
            this.headRendered = true;
            response.render(OnLoadHeaderItem.forScript(this.getJsTimeoutCall(this.updateInterval)));
        }
    }

    protected final String getJsTimeoutCall(Duration updateInterval) {
        CharSequence js = this.getCallbackScript();
        String timeoutHandle = this.getTimeoutHandle();
        return timeoutHandle + " = setTimeout('" + js + "', " + updateInterval.getMilliseconds() + ")";
    }

    private String getTimeoutHandle() {
        return "Wicket.timerHandle_" + this.getComponent().getMarkupId();
    }

    @Override
    protected final void respond(AjaxRequestTarget target) {
        if (!this.isStopped() && this.isEnabled(this.getComponent())) {
            this.onTimer(target);
            target.getHeaderResponse().render(OnLoadHeaderItem.forScript(this.getJsTimeoutCall(this.updateInterval)));
        }
    }

    protected abstract void onTimer(AjaxRequestTarget var1);

    public final boolean isStopped() {
        return this.stopped;
    }

    public final void restart(AjaxRequestTarget target) {
        if (this.isStopped()) {
            this.stopped = false;
            this.headRendered = false;
            target.add(this.getComponent());
        }
    }

    public final void stop(AjaxRequestTarget target) {
        this.stopped = true;
        String timeoutHandle = this.getTimeoutHandle();
        target.prependJavaScript("clearTimeout(" + timeoutHandle + "); delete " + timeoutHandle + ";");
    }
}

