/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.CssReferenceHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;
import org.apache.wicket.resource.bundles.ConcatResourceBundleReference;

public class ResourceBundles {
    private final ResourceReferenceRegistry registry;
    private final List<HeaderItem> bundles;
    private final Map<HeaderItem, HeaderItem> providedResourcesToBundles;

    public ResourceBundles(ResourceReferenceRegistry registry) {
        this.registry = registry;
        this.bundles = new ArrayList<HeaderItem>();
        this.providedResourcesToBundles = new HashMap<HeaderItem, HeaderItem>();
    }

    public JavaScriptReferenceHeaderItem addJavaScriptBundle(Class<?> scope, String name, PackageResourceReference ... references) {
        ArrayList<JavaScriptReferenceHeaderItem> items = new ArrayList<JavaScriptReferenceHeaderItem>();
        for (PackageResourceReference curReference : references) {
            items.add(JavaScriptHeaderItem.forReference(curReference));
        }
        return this.addBundle(JavaScriptHeaderItem.forReference(new ConcatResourceBundleReference(scope, name, items)));
    }

    public CssReferenceHeaderItem addCssBundle(Class<?> scope, String name, PackageResourceReference ... references) {
        ArrayList<CssReferenceHeaderItem> items = new ArrayList<CssReferenceHeaderItem>();
        for (PackageResourceReference curReference : references) {
            items.add(CssHeaderItem.forReference(curReference));
        }
        return this.addBundle(CssHeaderItem.forReference(new ConcatResourceBundleReference(scope, name, items)));
    }

    public <T extends HeaderItem> T addBundle(T bundle) {
        for (HeaderItem headerItem : bundle.getProvidedResources()) {
            if (this.providedResourcesToBundles.containsKey(headerItem)) {
                throw new IllegalArgumentException("Only one bundle can provide a certain resource. " + this.providedResourcesToBundles.get(headerItem) + " already provides the resource " + headerItem);
            }
            this.providedResourcesToBundles.put(headerItem, bundle);
        }
        this.bundles.add(bundle);
        if (bundle instanceof IReferenceHeaderItem) {
            this.registry.registerResourceReference(((IReferenceHeaderItem)((Object)bundle)).getReference());
        }
        return bundle;
    }

    public HeaderItem findBundle(HeaderItem item) {
        return this.providedResourcesToBundles.get(item);
    }
}

