/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.curve25519;

import org.whispersystems.curve25519.Curve25519KeyPair;
import org.whispersystems.curve25519.Curve25519Provider;
import org.whispersystems.curve25519.NoSuchProviderException;
import org.whispersystems.curve25519.SecureRandomProvider;

public class Curve25519 {
    public static final String NATIVE = "native";
    public static final String JAVA = "java";
    public static final String J2ME = "j2me";
    public static final String BEST = "best";
    private final Curve25519Provider provider;

    public static Curve25519 getInstance(String type) throws NoSuchProviderException {
        return Curve25519.getInstance(type, null);
    }

    public static Curve25519 getInstance(String type, SecureRandomProvider random) throws NoSuchProviderException {
        if (NATIVE.equals(type)) {
            return new Curve25519(Curve25519.constructNativeProvider(random));
        }
        if (JAVA.equals(type)) {
            return new Curve25519(Curve25519.constructJavaProvider(random));
        }
        if (J2ME.equals(type)) {
            return new Curve25519(Curve25519.constructJ2meProvider(random));
        }
        if (BEST.equals(type)) {
            return new Curve25519(Curve25519.constructOpportunisticProvider(random));
        }
        throw new NoSuchProviderException(type);
    }

    private Curve25519(Curve25519Provider provider) {
        this.provider = provider;
    }

    public boolean isNative() {
        return this.provider.isNative();
    }

    public Curve25519KeyPair generateKeyPair() {
        byte[] privateKey = this.provider.generatePrivateKey();
        byte[] publicKey = this.provider.generatePublicKey(privateKey);
        return new Curve25519KeyPair(publicKey, privateKey);
    }

    public byte[] calculateAgreement(byte[] publicKey, byte[] privateKey) {
        return this.provider.calculateAgreement(privateKey, publicKey);
    }

    public byte[] calculateSignature(byte[] privateKey, byte[] message) {
        byte[] random = this.provider.getRandom(64);
        return this.provider.calculateSignature(random, privateKey, message);
    }

    public boolean verifySignature(byte[] publicKey, byte[] message, byte[] signature) {
        return this.provider.verifySignature(publicKey, message, signature);
    }

    private static Curve25519Provider constructNativeProvider(SecureRandomProvider random) throws NoSuchProviderException {
        return Curve25519.constructClass("NativeCurve25519Provider", random);
    }

    private static Curve25519Provider constructJavaProvider(SecureRandomProvider random) throws NoSuchProviderException {
        return Curve25519.constructClass("JavaCurve25519Provider", random);
    }

    private static Curve25519Provider constructJ2meProvider(SecureRandomProvider random) throws NoSuchProviderException {
        return Curve25519.constructClass("J2meCurve25519Provider", random);
    }

    private static Curve25519Provider constructOpportunisticProvider(SecureRandomProvider random) throws NoSuchProviderException {
        return Curve25519.constructClass("OpportunisticCurve25519Provider", random);
    }

    private static Curve25519Provider constructClass(String name, SecureRandomProvider random) throws NoSuchProviderException {
        try {
            Curve25519Provider provider = (Curve25519Provider)Class.forName("org.whispersystems.curve25519." + name).newInstance();
            if (random != null) {
                provider.setRandomProvider(random);
            }
            return provider;
        }
        catch (InstantiationException e) {
            throw new NoSuchProviderException(e);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchProviderException(e);
        }
        catch (ClassNotFoundException e) {
            throw new NoSuchProviderException(e);
        }
    }
}

