/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.util;

import java.util.Vector;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.libaxolotl.IdentityKey;
import org.whispersystems.libaxolotl.IdentityKeyPair;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.state.PreKeyRecord;
import org.whispersystems.libaxolotl.state.SignedPreKeyRecord;
import org.whispersystems.libaxolotl.util.Medium;

public class KeyHelper {
    private KeyHelper() {
    }

    public static IdentityKeyPair generateIdentityKeyPair(SecureRandomProvider secureRandom) {
        ECKeyPair keyPair = Curve.generateKeyPair(secureRandom);
        IdentityKey publicKey = new IdentityKey(keyPair.getPublicKey());
        return new IdentityKeyPair(publicKey, keyPair.getPrivateKey());
    }

    public static int generateRegistrationId(SecureRandomProvider secureRandom, boolean extendedRange) {
        if (extendedRange) {
            return secureRandom.nextInt(0x7FFFFFFE) + 1;
        }
        return secureRandom.nextInt(16380) + 1;
    }

    public static int getRandomSequence(SecureRandomProvider secureRandomProvider, int max) {
        return secureRandomProvider.nextInt(max);
    }

    public static Vector generatePreKeys(SecureRandomProvider secureRandom, int start, int count) {
        Vector<PreKeyRecord> results = new Vector<PreKeyRecord>();
        --start;
        for (int i = 0; i < count; ++i) {
            results.addElement(new PreKeyRecord((start + i) % (Medium.MAX_VALUE - 1) + 1, Curve.generateKeyPair(secureRandom)));
        }
        return results;
    }

    public static PreKeyRecord generateLastResortPreKey(SecureRandomProvider secureRandom) {
        ECKeyPair keyPair = Curve.generateKeyPair(secureRandom);
        return new PreKeyRecord(Medium.MAX_VALUE, keyPair);
    }

    public static SignedPreKeyRecord generateSignedPreKey(SecureRandomProvider secureRandom, IdentityKeyPair identityKeyPair, int signedPreKeyId) throws InvalidKeyException {
        ECKeyPair keyPair = Curve.generateKeyPair(secureRandom);
        byte[] signature = Curve.calculateSignature(secureRandom, identityKeyPair.getPrivateKey(), keyPair.getPublicKey().serialize());
        return new SignedPreKeyRecord(signedPreKeyId, System.currentTimeMillis(), keyPair, signature);
    }

    public static ECKeyPair generateSenderSigningKey(SecureRandomProvider secureRandom) {
        return Curve.generateKeyPair(secureRandom);
    }

    public static byte[] generateSenderKey(SecureRandomProvider secureRandom) {
        byte[] key = new byte[32];
        secureRandom.nextBytes(key);
        return key;
    }

    public static int generateSenderKeyId(SecureRandomProvider secureRandom) {
        return secureRandom.nextInt(Integer.MAX_VALUE);
    }
}

