/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.j2me.ParseException;
import org.whispersystems.libaxolotl.util.Hex;

public class ByteUtil {
    public static byte[] combine(byte[] first, byte[] second) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(first);
            baos.write(second);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError(e);
        }
    }

    public static byte[] combine(byte[] first, byte[] second, byte[] third) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(first);
            baos.write(second);
            baos.write(third);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError(e);
        }
    }

    public static byte[][] split(byte[] input, int firstLength, int secondLength) {
        byte[][] parts = new byte[2][];
        parts[0] = new byte[firstLength];
        System.arraycopy(input, 0, parts[0], 0, firstLength);
        parts[1] = new byte[secondLength];
        System.arraycopy(input, firstLength, parts[1], 0, secondLength);
        return parts;
    }

    public static byte[][] split(byte[] input, int firstLength, int secondLength, int thirdLength) throws ParseException {
        if (input == null || firstLength < 0 || secondLength < 0 || thirdLength < 0 || input.length < firstLength + secondLength + thirdLength) {
            throw new ParseException("Input too small: " + (input == null ? null : Hex.toString(input)));
        }
        byte[][] parts = new byte[3][];
        parts[0] = new byte[firstLength];
        System.arraycopy(input, 0, parts[0], 0, firstLength);
        parts[1] = new byte[secondLength];
        System.arraycopy(input, firstLength, parts[1], 0, secondLength);
        parts[2] = new byte[thirdLength];
        System.arraycopy(input, firstLength + secondLength, parts[2], 0, thirdLength);
        return parts;
    }

    public static byte[] trim(byte[] input, int length) {
        byte[] result = new byte[length];
        System.arraycopy(input, 0, result, 0, result.length);
        return result;
    }

    public static byte[] copyFrom(byte[] input) {
        byte[] output = new byte[input.length];
        System.arraycopy(input, 0, output, 0, output.length);
        return output;
    }

    public static byte intsToByteHighAndLow(int highValue, int lowValue) {
        return (byte)((highValue << 4 | lowValue) & 0xFF);
    }

    public static int highBitsToInt(byte value) {
        return (value & 0xFF) >> 4;
    }

    public static int lowBitsToInt(byte value) {
        return value & 0xF;
    }

    public static int highBitsToMedium(int value) {
        return value >> 12;
    }

    public static int lowBitsToMedium(int value) {
        return value & 0xFFF;
    }

    public static byte[] shortToByteArray(int value) {
        byte[] bytes = new byte[2];
        ByteUtil.shortToByteArray(bytes, 0, value);
        return bytes;
    }

    public static int shortToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset + 1] = (byte)value;
        bytes[offset] = (byte)(value >> 8);
        return 2;
    }

    public static int shortToLittleEndianByteArray(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)value;
        bytes[offset + 1] = (byte)(value >> 8);
        return 2;
    }

    public static byte[] mediumToByteArray(int value) {
        byte[] bytes = new byte[3];
        ByteUtil.mediumToByteArray(bytes, 0, value);
        return bytes;
    }

    public static int mediumToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset + 2] = (byte)value;
        bytes[offset + 1] = (byte)(value >> 8);
        bytes[offset] = (byte)(value >> 16);
        return 3;
    }

    public static byte[] intToByteArray(int value) {
        byte[] bytes = new byte[4];
        ByteUtil.intToByteArray(bytes, 0, value);
        return bytes;
    }

    public static int intToByteArray(byte[] bytes, int offset, int value) {
        bytes[offset + 3] = (byte)value;
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset] = (byte)(value >> 24);
        return 4;
    }

    public static int intToLittleEndianByteArray(byte[] bytes, int offset, int value) {
        bytes[offset] = (byte)value;
        bytes[offset + 1] = (byte)(value >> 8);
        bytes[offset + 2] = (byte)(value >> 16);
        bytes[offset + 3] = (byte)(value >> 24);
        return 4;
    }

    public static byte[] longToByteArray(long l) {
        byte[] bytes = new byte[8];
        ByteUtil.longToByteArray(bytes, 0, l);
        return bytes;
    }

    public static int longToByteArray(byte[] bytes, int offset, long value) {
        bytes[offset + 7] = (byte)value;
        bytes[offset + 6] = (byte)(value >> 8);
        bytes[offset + 5] = (byte)(value >> 16);
        bytes[offset + 4] = (byte)(value >> 24);
        bytes[offset + 3] = (byte)(value >> 32);
        bytes[offset + 2] = (byte)(value >> 40);
        bytes[offset + 1] = (byte)(value >> 48);
        bytes[offset] = (byte)(value >> 56);
        return 8;
    }

    public static int longTo4ByteArray(byte[] bytes, int offset, long value) {
        bytes[offset + 3] = (byte)value;
        bytes[offset + 2] = (byte)(value >> 8);
        bytes[offset + 1] = (byte)(value >> 16);
        bytes[offset + 0] = (byte)(value >> 24);
        return 4;
    }

    public static int byteArrayToShort(byte[] bytes) {
        return ByteUtil.byteArrayToShort(bytes, 0);
    }

    public static int byteArrayToShort(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static int byteArrayToMedium(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset + 2] & 0xFF;
    }

    public static int byteArrayToInt(byte[] bytes) {
        return ByteUtil.byteArrayToInt(bytes, 0);
    }

    public static int byteArrayToInt(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static int byteArrayToIntLittleEndian(byte[] bytes, int offset) {
        return (bytes[offset + 3] & 0xFF) << 24 | (bytes[offset + 2] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset] & 0xFF;
    }

    public static long byteArrayToLong(byte[] bytes) {
        return ByteUtil.byteArrayToLong(bytes, 0);
    }

    public static long byteArray4ToLong(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static long byteArrayToLong(byte[] bytes, int offset) {
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | ((long)bytes[offset + 5] & 0xFFL) << 16 | ((long)bytes[offset + 6] & 0xFFL) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }
}

