/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.state;

import java.util.Vector;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.whispersystems.libaxolotl.IdentityKey;
import org.whispersystems.libaxolotl.IdentityKeyPair;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPrivateKey;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.kdf.HKDF;
import org.whispersystems.libaxolotl.logging.Log;
import org.whispersystems.libaxolotl.ratchet.ChainKey;
import org.whispersystems.libaxolotl.ratchet.MessageKeys;
import org.whispersystems.libaxolotl.ratchet.RootKey;
import org.whispersystems.libaxolotl.state.protos.SessionStructure;
import org.whispersystems.libaxolotl.util.Pair;
import org.whispersystems.libaxolotl.util.guava.Optional;

public class SessionState {
    private SessionStructure sessionStructure;

    public SessionState() {
        this.sessionStructure = new SessionStructure();
    }

    public SessionState(SessionStructure sessionStructure) {
        this.sessionStructure = sessionStructure;
    }

    public SessionState(SessionState copy) {
        this.sessionStructure = SessionStructure.fromBytes(copy.sessionStructure.toBytes());
    }

    public SessionStructure getStructure() {
        return this.sessionStructure;
    }

    public byte[] getAliceBaseKey() {
        return this.sessionStructure.getAlicebasekey();
    }

    public void setAliceBaseKey(byte[] aliceBaseKey) {
        this.sessionStructure.setAlicebasekey(aliceBaseKey);
    }

    public void setSessionVersion(int version) {
        this.sessionStructure.setSessionversion(version);
    }

    public int getSessionVersion() {
        int sessionVersion = this.sessionStructure.getSessionversion();
        if (sessionVersion == 0) {
            return 2;
        }
        return sessionVersion;
    }

    public void setRemoteIdentityKey(IdentityKey identityKey) {
        this.sessionStructure.setRemoteidentitypublic(identityKey.serialize());
    }

    public void setLocalIdentityKey(IdentityKey identityKey) {
        this.sessionStructure.setLocalidentitypublic(identityKey.serialize());
    }

    public IdentityKey getRemoteIdentityKey() {
        try {
            if (this.sessionStructure.getRemoteidentitypublic() == null) {
                return null;
            }
            return new IdentityKey(this.sessionStructure.getRemoteidentitypublic(), 0);
        }
        catch (InvalidKeyException e) {
            Log.w("SessionRecordV2", e);
            return null;
        }
    }

    public IdentityKey getLocalIdentityKey() {
        try {
            return new IdentityKey(this.sessionStructure.getLocalidentitypublic(), 0);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError(e);
        }
    }

    public int getPreviousCounter() {
        return this.sessionStructure.getPreviouscounter();
    }

    public void setPreviousCounter(int previousCounter) {
        this.sessionStructure.setPreviouscounter(previousCounter);
    }

    public RootKey getRootKey() {
        return new RootKey(HKDF.createFor(this.getSessionVersion()), this.sessionStructure.getRootkey());
    }

    public void setRootKey(RootKey rootKey) {
        this.sessionStructure.setRootkey(rootKey.getKeyBytes());
    }

    public ECPublicKey getSenderRatchetKey() {
        try {
            return Curve.decodePoint(this.sessionStructure.getSenderchain().getSenderratchetkey(), 0);
        }
        catch (InvalidKeyException e) {
            throw new AssertionError(e);
        }
    }

    public ECKeyPair getSenderRatchetKeyPair() {
        ECPublicKey publicKey = this.getSenderRatchetKey();
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getSenderchain().getSenderratchetkeyprivate());
        return new ECKeyPair(publicKey, privateKey);
    }

    public boolean hasReceiverChain(ECPublicKey senderEphemeral) {
        return this.getReceiverChain(senderEphemeral) != null;
    }

    public boolean hasSenderChain() {
        return this.sessionStructure.hasSenderchain();
    }

    private Pair getReceiverChain(ECPublicKey senderEphemeral) {
        Vector receiverChains = this.sessionStructure.getReceiverchainsVector();
        int index = 0;
        for (int i = 0; i < receiverChains.size(); ++i) {
            SessionStructure.Chain receiverChain = (SessionStructure.Chain)receiverChains.elementAt(i);
            try {
                ECPublicKey chainSenderRatchetKey = Curve.decodePoint(receiverChain.getSenderratchetkey(), 0);
                if (chainSenderRatchetKey.equals(senderEphemeral)) {
                    return new Pair(receiverChain, new Integer(index));
                }
            }
            catch (InvalidKeyException e) {
                Log.w("SessionRecordV2", e);
            }
            ++index;
        }
        return null;
    }

    public ChainKey getReceiverChainKey(ECPublicKey senderEphemeral) {
        Pair receiverChainAndIndex = this.getReceiverChain(senderEphemeral);
        SessionStructure.Chain receiverChain = (SessionStructure.Chain)receiverChainAndIndex.first();
        if (receiverChain == null) {
            return null;
        }
        return new ChainKey(HKDF.createFor(this.getSessionVersion()), receiverChain.getChainkey().getKey(), receiverChain.getChainkey().getIndex());
    }

    public void addReceiverChain(ECPublicKey senderRatchetKey, ChainKey chainKey) {
        SessionStructure.Chain.ChainKey chainKeyStructure = new SessionStructure.Chain.ChainKey();
        chainKeyStructure.setKey(chainKey.getKey());
        chainKeyStructure.setIndex(chainKey.getIndex());
        SessionStructure.Chain chain = new SessionStructure.Chain();
        chain.setChainkey(chainKeyStructure);
        chain.setSenderratchetkey(senderRatchetKey.serialize());
        this.sessionStructure.addReceiverchains(chain);
        if (this.sessionStructure.getReceiverchainsVector().size() > 5) {
            this.sessionStructure.getReceiverchainsVector().removeElementAt(0);
        }
    }

    public void setSenderChain(ECKeyPair senderRatchetKeyPair, ChainKey chainKey) {
        SessionStructure.Chain.ChainKey chainKeyStructure = new SessionStructure.Chain.ChainKey();
        chainKeyStructure.setKey(chainKey.getKey());
        chainKeyStructure.setIndex(chainKey.getIndex());
        SessionStructure.Chain senderChain = new SessionStructure.Chain();
        senderChain.setSenderratchetkey(senderRatchetKeyPair.getPublicKey().serialize());
        senderChain.setSenderratchetkeyprivate(senderRatchetKeyPair.getPrivateKey().serialize());
        senderChain.setChainkey(chainKeyStructure);
        this.sessionStructure.setSenderchain(senderChain);
    }

    public ChainKey getSenderChainKey() {
        SessionStructure.Chain.ChainKey chainKeyStructure = this.sessionStructure.getSenderchain().getChainkey();
        return new ChainKey(HKDF.createFor(this.getSessionVersion()), chainKeyStructure.getKey(), chainKeyStructure.getIndex());
    }

    public void setSenderChainKey(ChainKey nextChainKey) {
        SessionStructure.Chain.ChainKey chainKey = new SessionStructure.Chain.ChainKey();
        chainKey.setKey(nextChainKey.getKey());
        chainKey.setIndex(nextChainKey.getIndex());
        this.sessionStructure.getSenderchain().setChainkey(chainKey);
    }

    public boolean hasMessageKeys(ECPublicKey senderEphemeral, int counter) {
        Pair chainAndIndex = this.getReceiverChain(senderEphemeral);
        SessionStructure.Chain chain = (SessionStructure.Chain)chainAndIndex.first();
        if (chain == null) {
            return false;
        }
        Vector messageKeyList = chain.getMessagekeysVector();
        for (int i = 0; i < messageKeyList.size(); ++i) {
            SessionStructure.Chain.MessageKey messageKey = (SessionStructure.Chain.MessageKey)messageKeyList.elementAt(i);
            if (messageKey.getIndex() != counter) continue;
            return true;
        }
        return false;
    }

    public MessageKeys removeMessageKeys(ECPublicKey senderEphemeral, int counter) {
        Pair chainAndIndex = this.getReceiverChain(senderEphemeral);
        SessionStructure.Chain chain = (SessionStructure.Chain)chainAndIndex.first();
        if (chain == null) {
            return null;
        }
        Vector messageKeyList = chain.getMessagekeysVector();
        MessageKeys result = null;
        for (int i = 0; i < messageKeyList.size(); ++i) {
            SessionStructure.Chain.MessageKey messageKey = (SessionStructure.Chain.MessageKey)messageKeyList.elementAt(i);
            if (messageKey.getIndex() != counter) continue;
            result = new MessageKeys(new KeyParameter(messageKey.getCipherkey()), new KeyParameter(messageKey.getMackey()), new ParametersWithIV(null, messageKey.getIv()), messageKey.getIndex());
            messageKeyList.removeElementAt(i);
            break;
        }
        return result;
    }

    public void setMessageKeys(ECPublicKey senderEphemeral, MessageKeys messageKeys) {
        Pair chainAndIndex = this.getReceiverChain(senderEphemeral);
        SessionStructure.Chain chain = (SessionStructure.Chain)chainAndIndex.first();
        SessionStructure.Chain.MessageKey messageKeyStructure = new SessionStructure.Chain.MessageKey();
        messageKeyStructure.setCipherkey(messageKeys.getCipherKey().getKey());
        messageKeyStructure.setMackey(messageKeys.getMacKey().getKey());
        messageKeyStructure.setIndex(messageKeys.getCounter());
        messageKeyStructure.setIv(messageKeys.getIv().getIV());
        chain.addMessagekeys(messageKeyStructure);
    }

    public void setReceiverChainKey(ECPublicKey senderEphemeral, ChainKey chainKey) {
        Pair chainAndIndex = this.getReceiverChain(senderEphemeral);
        SessionStructure.Chain chain = (SessionStructure.Chain)chainAndIndex.first();
        SessionStructure.Chain.ChainKey chainKeyStructure = new SessionStructure.Chain.ChainKey();
        chainKeyStructure.setKey(chainKey.getKey());
        chainKeyStructure.setIndex(chainKey.getIndex());
        chain.setChainkey(chainKeyStructure);
    }

    public void setPendingKeyExchange(int sequence, ECKeyPair ourBaseKey, ECKeyPair ourRatchetKey, IdentityKeyPair ourIdentityKey) {
        SessionStructure.PendingKeyExchange structure = new SessionStructure.PendingKeyExchange();
        structure.setSequence(sequence);
        structure.setLocalbasekey(ourBaseKey.getPublicKey().serialize());
        structure.setLocalbasekeyprivate(ourBaseKey.getPrivateKey().serialize());
        structure.setLocalratchetkey(ourRatchetKey.getPublicKey().serialize());
        structure.setLocalratchetkeyprivate(ourRatchetKey.getPrivateKey().serialize());
        structure.setLocalidentitykey(ourIdentityKey.getPublicKey().serialize());
        structure.setLocalidentitykeyprivate(ourIdentityKey.getPrivateKey().serialize());
        this.sessionStructure.setPendingkeyexchange(structure);
    }

    public int getPendingKeyExchangeSequence() {
        return this.sessionStructure.getPendingkeyexchange().getSequence();
    }

    public ECKeyPair getPendingKeyExchangeBaseKey() throws InvalidKeyException {
        ECPublicKey publicKey = Curve.decodePoint(this.sessionStructure.getPendingkeyexchange().getLocalbasekey(), 0);
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getPendingkeyexchange().getLocalbasekeyprivate());
        return new ECKeyPair(publicKey, privateKey);
    }

    public ECKeyPair getPendingKeyExchangeRatchetKey() throws InvalidKeyException {
        ECPublicKey publicKey = Curve.decodePoint(this.sessionStructure.getPendingkeyexchange().getLocalratchetkey(), 0);
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getPendingkeyexchange().getLocalratchetkeyprivate());
        return new ECKeyPair(publicKey, privateKey);
    }

    public IdentityKeyPair getPendingKeyExchangeIdentityKey() throws InvalidKeyException {
        IdentityKey publicKey = new IdentityKey(this.sessionStructure.getPendingkeyexchange().getLocalidentitykey(), 0);
        ECPrivateKey privateKey = Curve.decodePrivatePoint(this.sessionStructure.getPendingkeyexchange().getLocalidentitykeyprivate());
        return new IdentityKeyPair(publicKey, privateKey);
    }

    public boolean hasPendingKeyExchange() {
        return this.sessionStructure.hasPendingkeyexchange();
    }

    public void setUnacknowledgedPreKeyMessage(Optional preKeyId, int signedPreKeyId, ECPublicKey baseKey) {
        SessionStructure.PendingPreKey pending = new SessionStructure.PendingPreKey();
        pending.setSignedprekeyid(signedPreKeyId);
        pending.setBasekey(baseKey.serialize());
        if (preKeyId.isPresent()) {
            pending.setPrekeyid((Integer)preKeyId.get());
        }
        this.sessionStructure.setPendingprekey(pending);
    }

    public boolean hasUnacknowledgedPreKeyMessage() {
        return this.sessionStructure.getPendingprekey() != null;
    }

    public UnacknowledgedPreKeyMessageItems getUnacknowledgedPreKeyMessageItems() {
        try {
            Optional preKeyId = this.sessionStructure.getPendingprekey().hasPrekeyid() ? Optional.of(new Integer(this.sessionStructure.getPendingprekey().getPrekeyid())) : Optional.absent();
            return new UnacknowledgedPreKeyMessageItems(preKeyId, this.sessionStructure.getPendingprekey().getSignedprekeyid(), Curve.decodePoint(this.sessionStructure.getPendingprekey().getBasekey(), 0));
        }
        catch (InvalidKeyException e) {
            throw new AssertionError(e);
        }
    }

    public void clearUnacknowledgedPreKeyMessage() {
        this.sessionStructure.clearPendingprekey();
    }

    public void setRemoteRegistrationId(int registrationId) {
        this.sessionStructure.setRemoteregistrationid(registrationId);
    }

    public int getRemoteRegistrationId() {
        return this.sessionStructure.getRemoteregistrationid();
    }

    public void setLocalRegistrationId(int registrationId) {
        this.sessionStructure.setLocalregistrationid(registrationId);
    }

    public int getLocalRegistrationId() {
        return this.sessionStructure.getLocalregistrationid();
    }

    public byte[] serialize() {
        return this.sessionStructure.toBytes();
    }

    public static class UnacknowledgedPreKeyMessageItems {
        private final Optional preKeyId;
        private final int signedPreKeyId;
        private final ECPublicKey baseKey;

        public UnacknowledgedPreKeyMessageItems(Optional preKeyId, int signedPreKeyId, ECPublicKey baseKey) {
            this.preKeyId = preKeyId;
            this.signedPreKeyId = signedPreKeyId;
            this.baseKey = baseKey;
        }

        public Optional getPreKeyId() {
            return this.preKeyId;
        }

        public int getSignedPreKeyId() {
            return this.signedPreKeyId;
        }

        public ECPublicKey getBaseKey() {
            return this.baseKey;
        }
    }
}

