/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.state;

import java.io.IOException;
import java.util.Vector;
import org.whispersystems.libaxolotl.j2me.Arrays;
import org.whispersystems.libaxolotl.state.SessionState;
import org.whispersystems.libaxolotl.state.protos.RecordStructure;
import org.whispersystems.libaxolotl.state.protos.SessionStructure;

public class SessionRecord {
    private static final int ARCHIVED_STATES_MAX_LENGTH = 40;
    private SessionState sessionState = new SessionState();
    private Vector previousStates = new Vector();
    private boolean fresh = false;

    public SessionRecord() {
        this.fresh = true;
    }

    public SessionRecord(SessionState sessionState) {
        this.sessionState = sessionState;
        this.fresh = false;
    }

    public SessionRecord(byte[] serialized) throws IOException {
        RecordStructure record = RecordStructure.fromBytes(serialized);
        this.sessionState = new SessionState(record.getCurrentsession());
        this.fresh = false;
        for (int i = 0; i < record.getPrevioussessionsVector().size(); ++i) {
            this.previousStates.addElement(new SessionState((SessionStructure)record.getPrevioussessionsVector().elementAt(i)));
        }
    }

    public boolean hasSessionState(int version, byte[] aliceBaseKey) {
        if (this.sessionState.getSessionVersion() == version && Arrays.equals(aliceBaseKey, this.sessionState.getAliceBaseKey())) {
            return true;
        }
        for (int i = 0; i < this.previousStates.size(); ++i) {
            SessionState state = (SessionState)this.previousStates.elementAt(i);
            if (state.getSessionVersion() != version || !Arrays.equals(aliceBaseKey, state.getAliceBaseKey())) continue;
            return true;
        }
        return false;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public Vector getPreviousSessionStates() {
        return this.previousStates;
    }

    public boolean isFresh() {
        return this.fresh;
    }

    public void archiveCurrentState() {
        this.promoteState(new SessionState());
    }

    public void promoteState(SessionState promotedState) {
        this.previousStates.insertElementAt(this.sessionState, 0);
        this.sessionState = promotedState;
        if (this.previousStates.size() > 40) {
            this.previousStates.removeElementAt(this.previousStates.size() - 1);
        }
    }

    public void setState(SessionState sessionState) {
        this.sessionState = sessionState;
    }

    public byte[] serialize() {
        RecordStructure record = new RecordStructure();
        record.setCurrentsession(this.sessionState.getStructure());
        for (int i = 0; i < this.previousStates.size(); ++i) {
            SessionState previousState = (SessionState)this.previousStates.elementAt(i);
            record.addPrevioussessions(previousState.getStructure());
        }
        return record.toBytes();
    }
}

