/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.ratchet;

import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.kdf.DerivedRootSecrets;
import org.whispersystems.libaxolotl.kdf.HKDF;
import org.whispersystems.libaxolotl.ratchet.ChainKey;
import org.whispersystems.libaxolotl.util.Pair;

public class RootKey {
    private final HKDF kdf;
    private final byte[] key;

    public RootKey(HKDF kdf, byte[] key) {
        this.kdf = kdf;
        this.key = key;
    }

    public byte[] getKeyBytes() {
        return this.key;
    }

    public Pair createChain(ECPublicKey theirRatchetKey, ECKeyPair ourRatchetKey) throws InvalidKeyException {
        byte[] sharedSecret = Curve.calculateAgreement(theirRatchetKey, ourRatchetKey.getPrivateKey());
        byte[] derivedSecretBytes = this.kdf.deriveSecrets(sharedSecret, this.key, "WhisperRatchet".getBytes(), 64);
        DerivedRootSecrets derivedSecrets = new DerivedRootSecrets(derivedSecretBytes);
        RootKey newRootKey = new RootKey(this.kdf, derivedSecrets.getRootKey());
        ChainKey newChainKey = new ChainKey(this.kdf, derivedSecrets.getChainKey(), 0);
        return new Pair(newRootKey, newChainKey);
    }
}

