/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.ratchet;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.whispersystems.libaxolotl.kdf.DerivedMessageSecrets;
import org.whispersystems.libaxolotl.kdf.HKDF;
import org.whispersystems.libaxolotl.ratchet.MessageKeys;

public class ChainKey {
    private static final byte[] MESSAGE_KEY_SEED = new byte[]{1};
    private static final byte[] CHAIN_KEY_SEED = new byte[]{2};
    private final HKDF kdf;
    private final byte[] key;
    private final int index;

    public ChainKey(HKDF kdf, byte[] key, int index) {
        this.kdf = kdf;
        this.key = key;
        this.index = index;
    }

    public byte[] getKey() {
        return this.key;
    }

    public int getIndex() {
        return this.index;
    }

    public ChainKey getNextChainKey() {
        byte[] nextKey = this.getBaseMaterial(CHAIN_KEY_SEED);
        return new ChainKey(this.kdf, nextKey, this.index + 1);
    }

    public MessageKeys getMessageKeys() {
        byte[] inputKeyMaterial = this.getBaseMaterial(MESSAGE_KEY_SEED);
        byte[] keyMaterialBytes = this.kdf.deriveSecrets(inputKeyMaterial, "WhisperMessageKeys".getBytes(), 80);
        DerivedMessageSecrets keyMaterial = new DerivedMessageSecrets(keyMaterialBytes);
        return new MessageKeys(keyMaterial.getCipherKey(), keyMaterial.getMacKey(), keyMaterial.getIv(), this.index);
    }

    private byte[] getBaseMaterial(byte[] seed) {
        HMac mac = new HMac((Digest)new SHA256Digest());
        byte[] output = new byte[mac.getMacSize()];
        mac.init((CipherParameters)new KeyParameter(this.key, 0, this.key.length));
        mac.update(seed, 0, seed.length);
        mac.doFinal(output, 0);
        return output;
    }
}

