/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.protocol;

import org.whispersystems.libaxolotl.IdentityKey;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.InvalidMessageException;
import org.whispersystems.libaxolotl.InvalidVersionException;
import org.whispersystems.libaxolotl.LegacyMessageException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.protocol.CiphertextMessage;
import org.whispersystems.libaxolotl.protocol.WhisperMessage;
import org.whispersystems.libaxolotl.util.ByteUtil;
import org.whispersystems.libaxolotl.util.guava.Optional;

public class PreKeyWhisperMessage
implements CiphertextMessage {
    private final int version;
    private final int registrationId;
    private final Optional preKeyId;
    private final int signedPreKeyId;
    private final ECPublicKey baseKey;
    private final IdentityKey identityKey;
    private final WhisperMessage message;
    private final byte[] serialized;

    public PreKeyWhisperMessage(byte[] serialized) throws InvalidMessageException, InvalidVersionException {
        try {
            this.version = ByteUtil.highBitsToInt(serialized[0]);
            if (this.version > 3) {
                throw new InvalidVersionException("Unknown version: " + this.version);
            }
            byte[] structureBytes = new byte[serialized.length - 1];
            System.arraycopy(serialized, 1, structureBytes, 0, structureBytes.length);
            org.whispersystems.libaxolotl.protocol.protos.PreKeyWhisperMessage structure = org.whispersystems.libaxolotl.protocol.protos.PreKeyWhisperMessage.fromBytes(structureBytes);
            if (this.version == 2 && !structure.hasPrekeyid() || this.version == 3 && !structure.hasSignedprekeyid() || !structure.hasBasekey() || !structure.hasIdentitykey() || !structure.hasMessage()) {
                throw new InvalidMessageException("Incomplete message.");
            }
            this.serialized = serialized;
            this.registrationId = structure.getRegistrationid();
            this.preKeyId = structure.hasPrekeyid() ? Optional.of(new Integer(structure.getPrekeyid())) : Optional.absent();
            this.signedPreKeyId = structure.hasSignedprekeyid() ? structure.getSignedprekeyid() : -1;
            this.baseKey = Curve.decodePoint(structure.getBasekey(), 0);
            this.identityKey = new IdentityKey(Curve.decodePoint(structure.getIdentitykey(), 0));
            this.message = new WhisperMessage(structure.getMessage());
        }
        catch (InvalidKeyException ike) {
            throw new InvalidMessageException(ike);
        }
        catch (LegacyMessageException e) {
            throw new InvalidMessageException(e);
        }
    }

    public PreKeyWhisperMessage(int messageVersion, int registrationId, Optional preKeyId, int signedPreKeyId, ECPublicKey baseKey, IdentityKey identityKey, WhisperMessage message) {
        this.version = messageVersion;
        this.registrationId = registrationId;
        this.preKeyId = preKeyId;
        this.signedPreKeyId = signedPreKeyId;
        this.baseKey = baseKey;
        this.identityKey = identityKey;
        this.message = message;
        org.whispersystems.libaxolotl.protocol.protos.PreKeyWhisperMessage builder = new org.whispersystems.libaxolotl.protocol.protos.PreKeyWhisperMessage();
        builder.setSignedprekeyid(signedPreKeyId);
        builder.setBasekey(baseKey.serialize());
        builder.setIdentitykey(identityKey.serialize());
        builder.setMessage(message.serialize());
        builder.setRegistrationid(registrationId);
        if (preKeyId.isPresent()) {
            builder.setPrekeyid((Integer)preKeyId.get());
        }
        byte[] versionBytes = new byte[]{ByteUtil.intsToByteHighAndLow(this.version, 3)};
        byte[] messageBytes = builder.toBytes();
        this.serialized = ByteUtil.combine(versionBytes, messageBytes);
    }

    public int getMessageVersion() {
        return this.version;
    }

    public IdentityKey getIdentityKey() {
        return this.identityKey;
    }

    public int getRegistrationId() {
        return this.registrationId;
    }

    public Optional getPreKeyId() {
        return this.preKeyId;
    }

    public int getSignedPreKeyId() {
        return this.signedPreKeyId;
    }

    public ECPublicKey getBaseKey() {
        return this.baseKey;
    }

    public WhisperMessage getWhisperMessage() {
        return this.message;
    }

    public byte[] serialize() {
        return this.serialized;
    }

    public int getType() {
        return 3;
    }
}

