/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.logging;

import org.whispersystems.libaxolotl.j2me.NestedException;
import org.whispersystems.libaxolotl.logging.AxolotlLogger;
import org.whispersystems.libaxolotl.logging.AxolotlLoggerProvider;

public class Log {
    private Log() {
    }

    public static void v(String tag, String msg) {
        Log.log(2, tag, msg);
    }

    public static void v(String tag, String msg, Throwable tr) {
        Log.log(2, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static void d(String tag, String msg) {
        Log.log(3, tag, msg);
    }

    public static void d(String tag, String msg, Throwable tr) {
        Log.log(3, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static void i(String tag, String msg) {
        Log.log(4, tag, msg);
    }

    public static void i(String tag, String msg, Throwable tr) {
        Log.log(4, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static void w(String tag, String msg) {
        Log.log(5, tag, msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        Log.log(5, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static void w(String tag, Throwable tr) {
        Log.log(5, tag, Log.getStackTraceString(tr));
    }

    public static void e(String tag, String msg) {
        Log.log(6, tag, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Log.log(6, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        String name = tr.toString();
        if (tr instanceof NestedException && ((NestedException)tr).getNested() != null) {
            name = name + "\nCaused by: " + ((NestedException)tr).getNested().toString();
        }
        return name;
    }

    private static void log(int priority, String tag, String msg) {
        AxolotlLogger logger = AxolotlLoggerProvider.getProvider();
        if (logger != null) {
            logger.log(priority, tag, msg);
        }
    }
}

