/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.kdf;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.kdf.HKDFv2;
import org.whispersystems.libaxolotl.kdf.HKDFv3;

public abstract class HKDF {
    private static final int HASH_OUTPUT_SIZE = 32;

    public static HKDF createFor(int messageVersion) {
        switch (messageVersion) {
            case 2: {
                return new HKDFv2();
            }
            case 3: {
                return new HKDFv3();
            }
        }
        throw new AssertionError("Unknown version: " + messageVersion);
    }

    public byte[] deriveSecrets(byte[] inputKeyMaterial, byte[] info, int outputLength) {
        byte[] salt = new byte[32];
        return this.deriveSecrets(inputKeyMaterial, salt, info, outputLength);
    }

    public byte[] deriveSecrets(byte[] inputKeyMaterial, byte[] salt, byte[] info, int outputLength) {
        byte[] prk = this.extract(salt, inputKeyMaterial);
        return this.expand(prk, info, outputLength);
    }

    private byte[] extract(byte[] salt, byte[] inputKeyMaterial) {
        HMac mac = new HMac((Digest)new SHA256Digest());
        byte[] output = new byte[mac.getMacSize()];
        mac.init((CipherParameters)new KeyParameter(salt, 0, salt.length));
        mac.update(inputKeyMaterial, 0, inputKeyMaterial.length);
        mac.doFinal(output, 0);
        return output;
    }

    private byte[] expand(byte[] prk, byte[] info, int outputSize) {
        int iterations = (int)Math.ceil((double)outputSize / 32.0);
        byte[] mixin = new byte[]{};
        ByteArrayOutputStream results = new ByteArrayOutputStream();
        int remainingBytes = outputSize;
        for (int i = this.getIterationStartOffset(); i < iterations + this.getIterationStartOffset(); ++i) {
            HMac mac = new HMac((Digest)new SHA256Digest());
            byte[] stepResult = new byte[mac.getMacSize()];
            mac.init((CipherParameters)new KeyParameter(prk, 0, prk.length));
            mac.update(mixin, 0, mixin.length);
            if (info != null) {
                mac.update(info, 0, info.length);
            }
            mac.update((byte)i);
            mac.doFinal(stepResult, 0);
            int stepSize = Math.min(remainingBytes, stepResult.length);
            results.write(stepResult, 0, stepSize);
            mixin = stepResult;
            remainingBytes -= stepSize;
        }
        return results.toByteArray();
    }

    protected abstract int getIterationStartOffset();
}

