/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.kdf;

import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.j2me.ParseException;
import org.whispersystems.libaxolotl.util.ByteUtil;

public class DerivedMessageSecrets {
    public static final int SIZE = 80;
    private static final int CIPHER_KEY_LENGTH = 32;
    private static final int MAC_KEY_LENGTH = 32;
    private static final int IV_LENGTH = 16;
    private final KeyParameter cipherKey;
    private final KeyParameter macKey;
    private final ParametersWithIV iv;

    public DerivedMessageSecrets(byte[] okm) {
        try {
            byte[][] keys = ByteUtil.split(okm, 32, 32, 16);
            this.cipherKey = new KeyParameter(keys[0], 0, keys[0].length);
            this.macKey = new KeyParameter(keys[1], 0, keys[1].length);
            this.iv = new ParametersWithIV(null, keys[2], 0, keys[2].length);
        }
        catch (ParseException e) {
            throw new AssertionError(e);
        }
    }

    public KeyParameter getCipherKey() {
        return this.cipherKey;
    }

    public KeyParameter getMacKey() {
        return this.macKey;
    }

    public ParametersWithIV getIv() {
        return this.iv;
    }
}

