/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.j2me;

public class BigInteger {
    final int signum;
    final int[] mag;
    static final long LONG_MASK = 0xFFFFFFFFL;
    private static final int MAX_MAG_LENGTH = 0x4000000;

    public BigInteger(byte[] val) {
        if (val.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (val[0] < 0) {
            this.mag = BigInteger.makePositive(val);
            this.signum = -1;
        } else {
            this.mag = BigInteger.stripLeadingZeroBytes(val);
            int n = this.signum = this.mag.length == 0 ? 0 : 1;
        }
        if (this.mag.length >= 0x4000000) {
            this.checkRange();
        }
    }

    private void checkRange() {
        if (this.mag.length > 0x4000000 || this.mag.length == 0x4000000 && this.mag[0] < 0) {
            BigInteger.reportOverflow();
        }
    }

    private static void reportOverflow() {
        throw new ArithmeticException("BigInteger would overflow supported range");
    }

    public int compareTo(BigInteger val) {
        if (this.signum == val.signum) {
            switch (this.signum) {
                case 1: {
                    return this.compareMagnitude(val);
                }
                case -1: {
                    return val.compareMagnitude(this);
                }
            }
            return 0;
        }
        return this.signum > val.signum ? 1 : -1;
    }

    final int compareMagnitude(BigInteger val) {
        int[] m1 = this.mag;
        int len1 = m1.length;
        int[] m2 = val.mag;
        int len2 = m2.length;
        if (len1 < len2) {
            return -1;
        }
        if (len1 > len2) {
            return 1;
        }
        for (int i = 0; i < len1; ++i) {
            int a = m1[i];
            int b = m2[i];
            if (a == b) continue;
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object x) {
        if (x == this) {
            return true;
        }
        if (!(x instanceof BigInteger)) {
            return false;
        }
        BigInteger xInt = (BigInteger)x;
        if (xInt.signum != this.signum) {
            return false;
        }
        int[] m = this.mag;
        int len = m.length;
        int[] xm = xInt.mag;
        if (len != xm.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (xm[i] == m[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.mag.length; ++i) {
            hashCode = (int)((long)(31 * hashCode) + ((long)this.mag[i] & 0xFFFFFFFFL));
        }
        return hashCode * this.signum;
    }

    private static int[] stripLeadingZeroBytes(byte[] a) {
        int keep;
        int byteLength = a.length;
        for (keep = 0; keep < byteLength && a[keep] == 0; ++keep) {
        }
        int intLength = byteLength - keep + 3 >>> 2;
        int[] result = new int[intLength];
        int b = byteLength - 1;
        for (int i = intLength - 1; i >= 0; --i) {
            result[i] = a[b--] & 0xFF;
            int bytesRemaining = b - keep + 1;
            int bytesToTransfer = Math.min(3, bytesRemaining);
            for (int j = 8; j <= bytesToTransfer << 3; j += 8) {
                int n = i;
                result[n] = result[n] | (a[b--] & 0xFF) << j;
            }
        }
        return result;
    }

    private static int[] makePositive(byte[] a) {
        int i;
        int k;
        int keep;
        int byteLength = a.length;
        for (keep = 0; keep < byteLength && a[keep] == -1; ++keep) {
        }
        for (k = keep; k < byteLength && a[k] == 0; ++k) {
        }
        int extraByte = k == byteLength ? 1 : 0;
        int intLength = byteLength - keep + extraByte + 3 >>> 2;
        int[] result = new int[intLength];
        int b = byteLength - 1;
        for (i = intLength - 1; i >= 0; --i) {
            result[i] = a[b--] & 0xFF;
            int numBytesToTransfer = Math.min(3, b - keep + 1);
            if (numBytesToTransfer < 0) {
                numBytesToTransfer = 0;
            }
            for (int j = 8; j <= 8 * numBytesToTransfer; j += 8) {
                int n = i;
                result[n] = result[n] | (a[b--] & 0xFF) << j;
            }
            int mask = -1 >>> 8 * (3 - numBytesToTransfer);
            result[i] = ~result[i] & mask;
        }
        for (i = result.length - 1; i >= 0; --i) {
            result[i] = (int)(((long)result[i] & 0xFFFFFFFFL) + 1L);
            if (result[i] != 0) break;
        }
        return result;
    }
}

