/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.groups.state;

import java.util.Vector;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPrivateKey;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.groups.ratchet.SenderChainKey;
import org.whispersystems.libaxolotl.groups.ratchet.SenderMessageKey;
import org.whispersystems.libaxolotl.state.protos.SenderKeyStateStructure;
import org.whispersystems.libaxolotl.util.guava.Optional;

public class SenderKeyState {
    private SenderKeyStateStructure senderKeyStateStructure;

    public SenderKeyState(int id, int iteration, byte[] chainKey, ECPublicKey signatureKey) {
        this(id, iteration, chainKey, signatureKey, Optional.absent());
    }

    public SenderKeyState(int id, int iteration, byte[] chainKey, ECKeyPair signatureKey) {
        this(id, iteration, chainKey, signatureKey.getPublicKey(), Optional.of(signatureKey.getPrivateKey()));
    }

    private SenderKeyState(int id, int iteration, byte[] chainKey, ECPublicKey signatureKeyPublic, Optional signatureKeyPrivate) {
        SenderKeyStateStructure.SenderChainKey senderChainKeyStructure = new SenderKeyStateStructure.SenderChainKey();
        senderChainKeyStructure.setIteration(iteration);
        senderChainKeyStructure.setSeed(chainKey);
        SenderKeyStateStructure.SenderSigningKey signingKeyStructure = new SenderKeyStateStructure.SenderSigningKey();
        signingKeyStructure.setPublic(signatureKeyPublic.serialize());
        if (signatureKeyPrivate.isPresent()) {
            signingKeyStructure.setPrivate(((ECPrivateKey)signatureKeyPrivate.get()).serialize());
        }
        this.senderKeyStateStructure = new SenderKeyStateStructure();
        this.senderKeyStateStructure.setSenderkeyid(id);
        this.senderKeyStateStructure.setSenderchainkey(senderChainKeyStructure);
        this.senderKeyStateStructure.setSendersigningkey(signingKeyStructure);
    }

    public SenderKeyState(SenderKeyStateStructure senderKeyStateStructure) {
        this.senderKeyStateStructure = senderKeyStateStructure;
    }

    public int getKeyId() {
        return this.senderKeyStateStructure.getSenderkeyid();
    }

    public SenderChainKey getSenderChainKey() {
        return new SenderChainKey(this.senderKeyStateStructure.getSenderchainkey().getIteration(), this.senderKeyStateStructure.getSenderchainkey().getSeed());
    }

    public void setSenderChainKey(SenderChainKey chainKey) {
        SenderKeyStateStructure.SenderChainKey senderChainKeyStructure = new SenderKeyStateStructure.SenderChainKey();
        senderChainKeyStructure.setIteration(chainKey.getIteration());
        senderChainKeyStructure.setSeed(chainKey.getSeed());
        this.senderKeyStateStructure.setSenderchainkey(senderChainKeyStructure);
    }

    public ECPublicKey getSigningKeyPublic() throws InvalidKeyException {
        return Curve.decodePoint(this.senderKeyStateStructure.getSendersigningkey().getPublic(), 0);
    }

    public ECPrivateKey getSigningKeyPrivate() {
        return Curve.decodePrivatePoint(this.senderKeyStateStructure.getSendersigningkey().getPrivate());
    }

    public boolean hasSenderMessageKey(int iteration) {
        for (int i = 0; i < this.senderKeyStateStructure.getSendermessagekeysVector().size(); ++i) {
            SenderKeyStateStructure.SenderMessageKey senderMessageKey = (SenderKeyStateStructure.SenderMessageKey)this.senderKeyStateStructure.getSendermessagekeysVector().elementAt(i);
            if (senderMessageKey.getIteration() != iteration) continue;
            return true;
        }
        return false;
    }

    public void addSenderMessageKey(SenderMessageKey senderMessageKey) {
        SenderKeyStateStructure.SenderMessageKey senderMessageKeyStructure = new SenderKeyStateStructure.SenderMessageKey();
        senderMessageKeyStructure.setIteration(senderMessageKey.getIteration());
        senderMessageKeyStructure.setSeed(senderMessageKey.getSeed());
        this.senderKeyStateStructure.addSendermessagekeys(senderMessageKeyStructure);
    }

    public SenderMessageKey removeSenderMessageKey(int iteration) {
        Vector keys = this.senderKeyStateStructure.getSendermessagekeysVector();
        SenderKeyStateStructure.SenderMessageKey result = null;
        for (int i = 0; i < keys.size(); ++i) {
            SenderKeyStateStructure.SenderMessageKey senderMessageKey = (SenderKeyStateStructure.SenderMessageKey)keys.elementAt(i);
            if (senderMessageKey.getIteration() != iteration) continue;
            result = senderMessageKey;
            keys.removeElementAt(i);
            break;
        }
        if (result != null) {
            return new SenderMessageKey(result.getIteration(), result.getSeed());
        }
        return null;
    }

    public SenderKeyStateStructure getStructure() {
        return this.senderKeyStateStructure;
    }
}

