/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.groups.state;

import java.io.IOException;
import java.util.Vector;
import org.whispersystems.libaxolotl.InvalidKeyIdException;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.groups.state.SenderKeyState;
import org.whispersystems.libaxolotl.state.protos.SenderKeyRecordStructure;
import org.whispersystems.libaxolotl.state.protos.SenderKeyStateStructure;

public class SenderKeyRecord {
    private Vector senderKeyStates = new Vector();

    public SenderKeyRecord() {
    }

    public SenderKeyRecord(byte[] serialized) throws IOException {
        SenderKeyRecordStructure senderKeyRecordStructure = SenderKeyRecordStructure.fromBytes(serialized);
        Vector senderKeyStates = senderKeyRecordStructure.getSenderkeystatesVector();
        for (int i = 0; i < senderKeyStates.size(); ++i) {
            this.senderKeyStates.addElement(new SenderKeyState((SenderKeyStateStructure)senderKeyStates.elementAt(i)));
        }
    }

    public boolean isEmpty() {
        return this.senderKeyStates.isEmpty();
    }

    public SenderKeyState getSenderKeyState() throws InvalidKeyIdException {
        if (!this.senderKeyStates.isEmpty()) {
            return (SenderKeyState)this.senderKeyStates.elementAt(0);
        }
        throw new InvalidKeyIdException("No key state in record!");
    }

    public SenderKeyState getSenderKeyState(int keyId) throws InvalidKeyIdException {
        for (int i = 0; i < this.senderKeyStates.size(); ++i) {
            if (((SenderKeyState)this.senderKeyStates.elementAt(i)).getKeyId() != keyId) continue;
            return (SenderKeyState)this.senderKeyStates.elementAt(i);
        }
        throw new InvalidKeyIdException("No keys for: " + keyId);
    }

    public void addSenderKeyState(int id, int iteration, byte[] chainKey, ECPublicKey signatureKey) {
        this.senderKeyStates.addElement(new SenderKeyState(id, iteration, chainKey, signatureKey));
    }

    public void setSenderKeyState(int id, int iteration, byte[] chainKey, ECKeyPair signatureKey) {
        this.senderKeyStates.removeAllElements();
        this.senderKeyStates.addElement(new SenderKeyState(id, iteration, chainKey, signatureKey));
    }

    public byte[] serialize() {
        SenderKeyRecordStructure recordStructure = new SenderKeyRecordStructure();
        for (int i = 0; i < this.senderKeyStates.size(); ++i) {
            SenderKeyState state = (SenderKeyState)this.senderKeyStates.elementAt(i);
            recordStructure.addSenderkeystates(state.getStructure());
        }
        return recordStructure.toBytes();
    }
}

