/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.groups.ratchet;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.whispersystems.libaxolotl.groups.ratchet.SenderMessageKey;

public class SenderChainKey {
    private static final byte[] MESSAGE_KEY_SEED = new byte[]{1};
    private static final byte[] CHAIN_KEY_SEED = new byte[]{2};
    private final int iteration;
    private final byte[] chainKey;

    public SenderChainKey(int iteration, byte[] chainKey) {
        this.iteration = iteration;
        this.chainKey = chainKey;
    }

    public int getIteration() {
        return this.iteration;
    }

    public SenderMessageKey getSenderMessageKey() {
        return new SenderMessageKey(this.iteration, this.getDerivative(MESSAGE_KEY_SEED, this.chainKey));
    }

    public SenderChainKey getNext() {
        return new SenderChainKey(this.iteration + 1, this.getDerivative(CHAIN_KEY_SEED, this.chainKey));
    }

    public byte[] getSeed() {
        return this.chainKey;
    }

    private byte[] getDerivative(byte[] seed, byte[] key) {
        HMac mac = new HMac((Digest)new SHA256Digest());
        byte[] output = new byte[32];
        mac.init((CipherParameters)new KeyParameter(key, 0, key.length));
        mac.update(seed, 0, seed.length);
        mac.doFinal(output, 0);
        return output;
    }
}

