/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.groups;

import org.whispersystems.libaxolotl.AxolotlAddress;

public class SenderKeyName {
    private final String groupId;
    private final AxolotlAddress sender;

    public SenderKeyName(String groupId, AxolotlAddress sender) {
        this.groupId = groupId;
        this.sender = sender;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public AxolotlAddress getSender() {
        return this.sender;
    }

    public String serialize() {
        return this.groupId + "::" + this.sender.getName() + "::" + String.valueOf(this.sender.getDeviceId());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SenderKeyName)) {
            return false;
        }
        SenderKeyName that = (SenderKeyName)other;
        return this.groupId.equals(that.groupId) && this.sender.equals(that.sender);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.groupId.hashCode();
        hash = 31 * hash + this.sender.hashCode();
        return hash;
    }
}

