/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.groups;

import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.InvalidKeyIdException;
import org.whispersystems.libaxolotl.groups.GroupCipher;
import org.whispersystems.libaxolotl.groups.SenderKeyName;
import org.whispersystems.libaxolotl.groups.state.SenderKeyRecord;
import org.whispersystems.libaxolotl.groups.state.SenderKeyState;
import org.whispersystems.libaxolotl.groups.state.SenderKeyStore;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.protocol.SenderKeyDistributionMessage;
import org.whispersystems.libaxolotl.util.KeyHelper;

public class GroupSessionBuilder {
    private final SenderKeyStore senderKeyStore;

    public GroupSessionBuilder(SenderKeyStore senderKeyStore) {
        this.senderKeyStore = senderKeyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SenderKeyName senderKeyName, SenderKeyDistributionMessage senderKeyDistributionMessage) {
        Object object = GroupCipher.LOCK;
        synchronized (object) {
            SenderKeyRecord senderKeyRecord = this.senderKeyStore.loadSenderKey(senderKeyName);
            senderKeyRecord.addSenderKeyState(senderKeyDistributionMessage.getId(), senderKeyDistributionMessage.getIteration(), senderKeyDistributionMessage.getChainKey(), senderKeyDistributionMessage.getSignatureKey());
            this.senderKeyStore.storeSenderKey(senderKeyName, senderKeyRecord);
        }
    }

    public SenderKeyDistributionMessage create(SenderKeyName senderKeyName, SecureRandomProvider secureRandomProvider) {
        Object object = GroupCipher.LOCK;
        synchronized (object) {
            try {
                SenderKeyRecord senderKeyRecord = this.senderKeyStore.loadSenderKey(senderKeyName);
                if (senderKeyRecord.isEmpty()) {
                    senderKeyRecord.setSenderKeyState(KeyHelper.generateSenderKeyId(secureRandomProvider), 0, KeyHelper.generateSenderKey(secureRandomProvider), KeyHelper.generateSenderSigningKey(secureRandomProvider));
                    this.senderKeyStore.storeSenderKey(senderKeyName, senderKeyRecord);
                }
                SenderKeyState state = senderKeyRecord.getSenderKeyState();
                return new SenderKeyDistributionMessage(state.getKeyId(), state.getSenderChainKey().getIteration(), state.getSenderChainKey().getSeed(), state.getSigningKeyPublic());
            }
            catch (InvalidKeyIdException e) {
                throw new AssertionError(e);
            }
            catch (InvalidKeyException e) {
                throw new AssertionError(e);
            }
        }
    }
}

