/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.groups;

import java.io.IOException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.libaxolotl.DuplicateMessageException;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.InvalidKeyIdException;
import org.whispersystems.libaxolotl.InvalidMessageException;
import org.whispersystems.libaxolotl.LegacyMessageException;
import org.whispersystems.libaxolotl.NoSessionException;
import org.whispersystems.libaxolotl.groups.SenderKeyName;
import org.whispersystems.libaxolotl.groups.ratchet.SenderChainKey;
import org.whispersystems.libaxolotl.groups.ratchet.SenderMessageKey;
import org.whispersystems.libaxolotl.groups.state.SenderKeyRecord;
import org.whispersystems.libaxolotl.groups.state.SenderKeyState;
import org.whispersystems.libaxolotl.groups.state.SenderKeyStore;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.protocol.SenderKeyMessage;

public class GroupCipher {
    static final Object LOCK = new Object();
    private final SecureRandomProvider secureRandomProvider;
    private final SenderKeyStore senderKeyStore;
    private final SenderKeyName senderKeyId;

    public GroupCipher(SecureRandomProvider secureRandomProvider, SenderKeyStore senderKeyStore, SenderKeyName senderKeyId) {
        this.secureRandomProvider = secureRandomProvider;
        this.senderKeyStore = senderKeyStore;
        this.senderKeyId = senderKeyId;
    }

    public byte[] encrypt(byte[] paddedPlaintext) throws NoSessionException {
        Object object = LOCK;
        synchronized (object) {
            try {
                SenderKeyRecord record = this.senderKeyStore.loadSenderKey(this.senderKeyId);
                SenderKeyState senderKeyState = record.getSenderKeyState();
                SenderMessageKey senderKey = senderKeyState.getSenderChainKey().getSenderMessageKey();
                byte[] ciphertext = this.getCipherText(senderKey.getIv(), senderKey.getCipherKey(), paddedPlaintext);
                SenderKeyMessage senderKeyMessage = new SenderKeyMessage(this.secureRandomProvider, senderKeyState.getKeyId(), senderKey.getIteration(), ciphertext, senderKeyState.getSigningKeyPrivate());
                senderKeyState.setSenderChainKey(senderKeyState.getSenderChainKey().getNext());
                this.senderKeyStore.storeSenderKey(this.senderKeyId, record);
                return senderKeyMessage.serialize();
            }
            catch (InvalidKeyIdException e) {
                throw new NoSessionException(e);
            }
        }
    }

    public byte[] decrypt(byte[] senderKeyMessageBytes) throws LegacyMessageException, InvalidMessageException, DuplicateMessageException {
        Object object = LOCK;
        synchronized (object) {
            try {
                SenderKeyRecord record = this.senderKeyStore.loadSenderKey(this.senderKeyId);
                SenderKeyMessage senderKeyMessage = new SenderKeyMessage(senderKeyMessageBytes);
                SenderKeyState senderKeyState = record.getSenderKeyState(senderKeyMessage.getKeyId());
                senderKeyMessage.verifySignature(senderKeyState.getSigningKeyPublic());
                SenderMessageKey senderKey = this.getSenderKey(senderKeyState, senderKeyMessage.getIteration());
                byte[] plaintext = this.getPlainText(senderKey.getIv(), senderKey.getCipherKey(), senderKeyMessage.getCipherText());
                this.senderKeyStore.storeSenderKey(this.senderKeyId, record);
                return plaintext;
            }
            catch (InvalidKeyException ike) {
                throw new InvalidMessageException(ike);
            }
            catch (InvalidKeyIdException ikie) {
                throw new InvalidMessageException(ikie);
            }
        }
    }

    private SenderMessageKey getSenderKey(SenderKeyState senderKeyState, int iteration) throws DuplicateMessageException, InvalidMessageException {
        SenderChainKey senderChainKey = senderKeyState.getSenderChainKey();
        if (senderChainKey.getIteration() > iteration) {
            if (senderKeyState.hasSenderMessageKey(iteration)) {
                return senderKeyState.removeSenderMessageKey(iteration);
            }
            throw new DuplicateMessageException("Received message with old counter: " + senderChainKey.getIteration() + " , " + iteration);
        }
        if (senderChainKey.getIteration() - iteration > 2000) {
            throw new InvalidMessageException("Over 2000 messages into the future!");
        }
        while (senderChainKey.getIteration() < iteration) {
            senderKeyState.addSenderMessageKey(senderChainKey.getSenderMessageKey());
            senderChainKey = senderChainKey.getNext();
        }
        senderKeyState.setSenderChainKey(senderChainKey.getNext());
        return senderChainKey.getSenderMessageKey();
    }

    private byte[] getPlainText(byte[] iv, byte[] key, byte[] ciphertext) throws InvalidMessageException {
        try {
            return this.cipher(false, iv, key, ciphertext);
        }
        catch (InvalidCipherTextException e) {
            throw new InvalidMessageException(e);
        }
        catch (IOException e) {
            throw new InvalidMessageException(e);
        }
    }

    private byte[] getCipherText(byte[] iv, byte[] key, byte[] plaintext) {
        try {
            return this.cipher(true, iv, key, plaintext);
        }
        catch (InvalidCipherTextException e) {
            throw new AssertionError(e);
        }
        catch (IOException e) {
            throw new AssertionError(e);
        }
    }

    private byte[] cipher(boolean encrypt, byte[] iv, byte[] key, byte[] input) throws InvalidCipherTextException, IOException {
        KeyParameter keyParameter = new KeyParameter(key, 0, key.length);
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        cipher.init(encrypt, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, iv, 0, iv.length));
        byte[] buffer = new byte[cipher.getOutputSize(input.length)];
        int processed = cipher.processBytes(input, 0, input.length, buffer, 0);
        int finished = cipher.doFinal(buffer, processed);
        if (processed + finished < buffer.length) {
            byte[] trimmed = new byte[processed + finished];
            System.arraycopy(buffer, 0, trimmed, 0, trimmed.length);
            return trimmed;
        }
        return buffer;
    }
}

