/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.ecc;

import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.j2me.Arrays;
import org.whispersystems.libaxolotl.j2me.BigInteger;
import org.whispersystems.libaxolotl.util.ByteUtil;

public class DjbECPublicKey
implements ECPublicKey {
    private final byte[] publicKey;

    DjbECPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public byte[] serialize() {
        byte[] type = new byte[]{5};
        return ByteUtil.combine(type, this.publicKey);
    }

    public int getType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof DjbECPublicKey)) {
            return false;
        }
        DjbECPublicKey that = (DjbECPublicKey)other;
        return Arrays.equals(this.publicKey, that.publicKey);
    }

    public int hashCode() {
        return Arrays.hashCode(this.publicKey);
    }

    public int compareTo(ECPublicKey another) {
        return new BigInteger(this.publicKey).compareTo(new BigInteger(((DjbECPublicKey)another).publicKey));
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }
}

