/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl.ecc;

import org.whispersystems.curve25519.Curve25519;
import org.whispersystems.curve25519.Curve25519KeyPair;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.ecc.DjbECPrivateKey;
import org.whispersystems.libaxolotl.ecc.DjbECPublicKey;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPrivateKey;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;

public class Curve {
    public static final int DJB_TYPE = 5;

    public static boolean isNative() {
        return Curve25519.getInstance((String)"j2me").isNative();
    }

    public static ECKeyPair generateKeyPair(SecureRandomProvider secureRandom) {
        Curve25519KeyPair keyPair = Curve25519.getInstance((String)"j2me", (SecureRandomProvider)secureRandom).generateKeyPair();
        return new ECKeyPair(new DjbECPublicKey(keyPair.getPublicKey()), new DjbECPrivateKey(keyPair.getPrivateKey()));
    }

    public static ECPublicKey decodePoint(byte[] bytes, int offset) throws InvalidKeyException {
        int type = bytes[offset] & 0xFF;
        switch (type) {
            case 5: {
                byte[] keyBytes = new byte[32];
                System.arraycopy(bytes, offset + 1, keyBytes, 0, keyBytes.length);
                return new DjbECPublicKey(keyBytes);
            }
        }
        throw new InvalidKeyException("Bad key type: " + type);
    }

    public static ECPrivateKey decodePrivatePoint(byte[] bytes) {
        return new DjbECPrivateKey(bytes);
    }

    public static byte[] calculateAgreement(ECPublicKey publicKey, ECPrivateKey privateKey) throws InvalidKeyException {
        if (publicKey.getType() != privateKey.getType()) {
            throw new InvalidKeyException("Public and private keys must be of the same type!");
        }
        if (publicKey.getType() == 5) {
            return Curve25519.getInstance((String)"j2me").calculateAgreement(((DjbECPublicKey)publicKey).getPublicKey(), ((DjbECPrivateKey)privateKey).getPrivateKey());
        }
        throw new InvalidKeyException("Unknown type: " + publicKey.getType());
    }

    public static boolean verifySignature(ECPublicKey signingKey, byte[] message, byte[] signature) throws InvalidKeyException {
        if (signingKey.getType() == 5) {
            return Curve25519.getInstance((String)"j2me").verifySignature(((DjbECPublicKey)signingKey).getPublicKey(), message, signature);
        }
        throw new InvalidKeyException("Unknown type: " + signingKey.getType());
    }

    public static byte[] calculateSignature(SecureRandomProvider secureRandom, ECPrivateKey signingKey, byte[] message) throws InvalidKeyException {
        if (signingKey.getType() == 5) {
            return Curve25519.getInstance((String)"j2me", (SecureRandomProvider)secureRandom).calculateSignature(((DjbECPrivateKey)signingKey).getPrivateKey(), message);
        }
        throw new InvalidKeyException("Unknown type: " + signingKey.getType());
    }
}

