/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl;

import java.util.Vector;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.libaxolotl.AxolotlAddress;
import org.whispersystems.libaxolotl.DuplicateMessageException;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.InvalidKeyIdException;
import org.whispersystems.libaxolotl.InvalidMessageException;
import org.whispersystems.libaxolotl.LegacyMessageException;
import org.whispersystems.libaxolotl.NoSessionException;
import org.whispersystems.libaxolotl.SessionBuilder;
import org.whispersystems.libaxolotl.UntrustedIdentityException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.protocol.CiphertextMessage;
import org.whispersystems.libaxolotl.protocol.PreKeyWhisperMessage;
import org.whispersystems.libaxolotl.protocol.WhisperMessage;
import org.whispersystems.libaxolotl.ratchet.ChainKey;
import org.whispersystems.libaxolotl.ratchet.MessageKeys;
import org.whispersystems.libaxolotl.ratchet.RootKey;
import org.whispersystems.libaxolotl.state.AxolotlStore;
import org.whispersystems.libaxolotl.state.IdentityKeyStore;
import org.whispersystems.libaxolotl.state.PreKeyStore;
import org.whispersystems.libaxolotl.state.SessionRecord;
import org.whispersystems.libaxolotl.state.SessionState;
import org.whispersystems.libaxolotl.state.SessionStore;
import org.whispersystems.libaxolotl.state.SignedPreKeyStore;
import org.whispersystems.libaxolotl.util.ByteUtil;
import org.whispersystems.libaxolotl.util.Pair;
import org.whispersystems.libaxolotl.util.guava.Optional;

public class SessionCipher {
    public static final Object SESSION_LOCK = new Object();
    private final SecureRandomProvider secureRandomProvider;
    private final SessionStore sessionStore;
    private final SessionBuilder sessionBuilder;
    private final PreKeyStore preKeyStore;
    private final AxolotlAddress remoteAddress;

    public SessionCipher(SecureRandomProvider secureRandomProvider, SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, IdentityKeyStore identityKeyStore, AxolotlAddress remoteAddress) {
        this.secureRandomProvider = secureRandomProvider;
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.remoteAddress = remoteAddress;
        this.sessionBuilder = new SessionBuilder(secureRandomProvider, sessionStore, preKeyStore, signedPreKeyStore, identityKeyStore, remoteAddress);
    }

    public SessionCipher(SecureRandomProvider secureRandomProvider, AxolotlStore store, AxolotlAddress remoteAddress) {
        this(secureRandomProvider, store, store, store, store, remoteAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CiphertextMessage encrypt(byte[] paddedMessage) {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            SessionState sessionState = sessionRecord.getSessionState();
            ChainKey chainKey = sessionState.getSenderChainKey();
            MessageKeys messageKeys = chainKey.getMessageKeys();
            ECPublicKey senderEphemeral = sessionState.getSenderRatchetKey();
            int previousCounter = sessionState.getPreviousCounter();
            int sessionVersion = sessionState.getSessionVersion();
            byte[] ciphertextBody = this.getCiphertext(sessionVersion, messageKeys, paddedMessage);
            CiphertextMessage ciphertextMessage = new WhisperMessage(sessionVersion, messageKeys.getMacKey(), senderEphemeral, chainKey.getIndex(), previousCounter, ciphertextBody, sessionState.getLocalIdentityKey(), sessionState.getRemoteIdentityKey());
            if (sessionState.hasUnacknowledgedPreKeyMessage()) {
                SessionState.UnacknowledgedPreKeyMessageItems items = sessionState.getUnacknowledgedPreKeyMessageItems();
                int localRegistrationId = sessionState.getLocalRegistrationId();
                ciphertextMessage = new PreKeyWhisperMessage(sessionVersion, localRegistrationId, items.getPreKeyId(), items.getSignedPreKeyId(), items.getBaseKey(), sessionState.getLocalIdentityKey(), (WhisperMessage)ciphertextMessage);
            }
            sessionState.setSenderChainKey(chainKey.getNextChainKey());
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            return ciphertextMessage;
        }
    }

    public byte[] decrypt(PreKeyWhisperMessage ciphertext) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        return this.decrypt(ciphertext, (DecryptionCallback)new NullDecryptionCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(PreKeyWhisperMessage ciphertext, DecryptionCallback callback) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException, InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            Optional unsignedPreKeyId = this.sessionBuilder.process(sessionRecord, ciphertext);
            byte[] plaintext = this.decrypt(sessionRecord, ciphertext.getWhisperMessage());
            callback.handlePlaintext(plaintext);
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            if (unsignedPreKeyId.isPresent()) {
                this.preKeyStore.removePreKey((Integer)unsignedPreKeyId.get());
            }
            return plaintext;
        }
    }

    public byte[] decrypt(WhisperMessage ciphertext) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException, NoSessionException {
        return this.decrypt(ciphertext, (DecryptionCallback)new NullDecryptionCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(WhisperMessage ciphertext, DecryptionCallback callback) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException, NoSessionException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            if (!this.sessionStore.containsSession(this.remoteAddress)) {
                throw new NoSessionException("No session for: " + this.remoteAddress);
            }
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            byte[] plaintext = this.decrypt(sessionRecord, ciphertext);
            callback.handlePlaintext(plaintext);
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            return plaintext;
        }
    }

    private byte[] decrypt(SessionRecord sessionRecord, WhisperMessage ciphertext) throws DuplicateMessageException, LegacyMessageException, InvalidMessageException {
        Object object = SESSION_LOCK;
        synchronized (object) {
            Vector previousStates = sessionRecord.getPreviousSessionStates();
            Vector<InvalidMessageException> exceptions = new Vector<InvalidMessageException>();
            try {
                SessionState sessionState = new SessionState(sessionRecord.getSessionState());
                byte[] plaintext = this.decrypt(sessionState, ciphertext);
                sessionRecord.setState(sessionState);
                return plaintext;
            }
            catch (InvalidMessageException e) {
                exceptions.addElement(e);
                for (int i = 0; i < previousStates.size(); ++i) {
                    try {
                        SessionState promotedState = new SessionState((SessionState)previousStates.elementAt(i));
                        byte[] plaintext = this.decrypt(promotedState, ciphertext);
                        previousStates.removeElementAt(i);
                        sessionRecord.promoteState(promotedState);
                        return plaintext;
                    }
                    catch (InvalidMessageException e2) {
                        exceptions.addElement(e2);
                        continue;
                    }
                }
                throw new InvalidMessageException("No valid sessions.", exceptions);
            }
        }
    }

    private byte[] decrypt(SessionState sessionState, WhisperMessage ciphertextMessage) throws InvalidMessageException, DuplicateMessageException, LegacyMessageException {
        if (!sessionState.hasSenderChain()) {
            throw new InvalidMessageException("Uninitialized session!");
        }
        if (ciphertextMessage.getMessageVersion() != sessionState.getSessionVersion()) {
            throw new InvalidMessageException("Message version: " + ciphertextMessage.getMessageVersion() + ", but session version: " + sessionState.getSessionVersion());
        }
        int messageVersion = ciphertextMessage.getMessageVersion();
        ECPublicKey theirEphemeral = ciphertextMessage.getSenderRatchetKey();
        int counter = ciphertextMessage.getCounter();
        ChainKey chainKey = this.getOrCreateChainKey(sessionState, theirEphemeral);
        MessageKeys messageKeys = this.getOrCreateMessageKeys(sessionState, theirEphemeral, chainKey, counter);
        ciphertextMessage.verifyMac(messageVersion, sessionState.getRemoteIdentityKey(), sessionState.getLocalIdentityKey(), messageKeys.getMacKey());
        byte[] plaintext = this.getPlaintext(messageVersion, messageKeys, ciphertextMessage.getBody());
        sessionState.clearUnacknowledgedPreKeyMessage();
        return plaintext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRemoteRegistrationId() {
        Object object = SESSION_LOCK;
        synchronized (object) {
            SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
            return record.getSessionState().getRemoteRegistrationId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionVersion() {
        Object object = SESSION_LOCK;
        synchronized (object) {
            if (!this.sessionStore.containsSession(this.remoteAddress)) {
                throw new IllegalStateException("No session for (" + this.remoteAddress + ")");
            }
            SessionRecord record = this.sessionStore.loadSession(this.remoteAddress);
            return record.getSessionState().getSessionVersion();
        }
    }

    private ChainKey getOrCreateChainKey(SessionState sessionState, ECPublicKey theirEphemeral) throws InvalidMessageException {
        try {
            if (sessionState.hasReceiverChain(theirEphemeral)) {
                return sessionState.getReceiverChainKey(theirEphemeral);
            }
            RootKey rootKey = sessionState.getRootKey();
            ECKeyPair ourEphemeral = sessionState.getSenderRatchetKeyPair();
            Pair receiverChain = rootKey.createChain(theirEphemeral, ourEphemeral);
            ECKeyPair ourNewEphemeral = Curve.generateKeyPair(this.secureRandomProvider);
            Pair senderChain = ((RootKey)receiverChain.first()).createChain(theirEphemeral, ourNewEphemeral);
            sessionState.setRootKey((RootKey)senderChain.first());
            sessionState.addReceiverChain(theirEphemeral, (ChainKey)receiverChain.second());
            sessionState.setPreviousCounter(Math.max(sessionState.getSenderChainKey().getIndex() - 1, 0));
            sessionState.setSenderChain(ourNewEphemeral, (ChainKey)senderChain.second());
            return (ChainKey)receiverChain.second();
        }
        catch (InvalidKeyException e) {
            throw new InvalidMessageException(e);
        }
    }

    private MessageKeys getOrCreateMessageKeys(SessionState sessionState, ECPublicKey theirEphemeral, ChainKey chainKey, int counter) throws InvalidMessageException, DuplicateMessageException {
        if (chainKey.getIndex() > counter) {
            if (sessionState.hasMessageKeys(theirEphemeral, counter)) {
                return sessionState.removeMessageKeys(theirEphemeral, counter);
            }
            throw new DuplicateMessageException("Received message with old counter: " + chainKey.getIndex() + " , " + counter);
        }
        if (counter - chainKey.getIndex() > 2000) {
            throw new InvalidMessageException("Over 2000 messages into the future!");
        }
        while (chainKey.getIndex() < counter) {
            MessageKeys messageKeys = chainKey.getMessageKeys();
            sessionState.setMessageKeys(theirEphemeral, messageKeys);
            chainKey = chainKey.getNextChainKey();
        }
        sessionState.setReceiverChainKey(theirEphemeral, chainKey.getNextChainKey());
        return chainKey.getMessageKeys();
    }

    private byte[] getCiphertext(int version, MessageKeys messageKeys, byte[] plaintext) {
        try {
            Object cipher = version >= 3 ? this.getCipher(true, new ParametersWithIV((CipherParameters)messageKeys.getCipherKey(), messageKeys.getIv().getIV())) : this.getCipher(true, messageKeys.getCipherKey(), messageKeys.getCounter());
            byte[] output = new byte[cipher.getOutputSize(plaintext.length)];
            int processed = cipher.processBytes(plaintext, 0, plaintext.length, output, 0);
            int finished = cipher.doFinal(output, processed);
            if (processed + finished < output.length) {
                byte[] trimmed = new byte[processed + finished];
                System.arraycopy(output, 0, trimmed, 0, trimmed.length);
                return trimmed;
            }
            return output;
        }
        catch (InvalidCipherTextException e) {
            throw new AssertionError(e);
        }
    }

    private byte[] getPlaintext(int version, MessageKeys messageKeys, byte[] cipherText) throws InvalidMessageException {
        try {
            Object cipher = version >= 3 ? this.getCipher(false, new ParametersWithIV((CipherParameters)messageKeys.getCipherKey(), messageKeys.getIv().getIV())) : this.getCipher(false, messageKeys.getCipherKey(), messageKeys.getCounter());
            byte[] output = new byte[cipher.getOutputSize(cipherText.length)];
            int processed = cipher.processBytes(cipherText, 0, cipherText.length, output, 0);
            int finished = cipher.doFinal(output, processed);
            if (processed + finished < output.length) {
                byte[] trimmed = new byte[processed + finished];
                System.arraycopy(output, 0, trimmed, 0, trimmed.length);
                return trimmed;
            }
            return output;
        }
        catch (InvalidCipherTextException icte) {
            throw new InvalidMessageException(icte);
        }
    }

    private BufferedBlockCipher getCipher(boolean encrypt, KeyParameter key, int counter) {
        byte[] ivBytes = new byte[16];
        ByteUtil.intToByteArray(ivBytes, 0, counter);
        BufferedBlockCipher cipher = new BufferedBlockCipher((BlockCipher)new SICBlockCipher((BlockCipher)new AESEngine()));
        cipher.init(encrypt, (CipherParameters)new ParametersWithIV((CipherParameters)key, ivBytes));
        return cipher;
    }

    private PaddedBufferedBlockCipher getCipher(boolean encrypt, ParametersWithIV iv) {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        cipher.init(encrypt, (CipherParameters)iv);
        return cipher;
    }

    private static class NullDecryptionCallback
    implements DecryptionCallback {
        private NullDecryptionCallback() {
        }

        public void handlePlaintext(byte[] plaintext) {
        }
    }

    public static interface DecryptionCallback {
        public void handlePlaintext(byte[] var1);
    }
}

