/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl;

import org.whispersystems.curve25519.SecureRandomProvider;
import org.whispersystems.libaxolotl.AxolotlAddress;
import org.whispersystems.libaxolotl.IdentityKey;
import org.whispersystems.libaxolotl.IdentityKeyPair;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.InvalidKeyIdException;
import org.whispersystems.libaxolotl.SessionCipher;
import org.whispersystems.libaxolotl.StaleKeyExchangeException;
import org.whispersystems.libaxolotl.UntrustedIdentityException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECKeyPair;
import org.whispersystems.libaxolotl.ecc.ECPublicKey;
import org.whispersystems.libaxolotl.j2me.AssertionError;
import org.whispersystems.libaxolotl.logging.Log;
import org.whispersystems.libaxolotl.protocol.KeyExchangeMessage;
import org.whispersystems.libaxolotl.protocol.PreKeyWhisperMessage;
import org.whispersystems.libaxolotl.ratchet.AliceAxolotlParameters;
import org.whispersystems.libaxolotl.ratchet.BobAxolotlParameters;
import org.whispersystems.libaxolotl.ratchet.RatchetingSession;
import org.whispersystems.libaxolotl.ratchet.SymmetricAxolotlParameters;
import org.whispersystems.libaxolotl.state.AxolotlStore;
import org.whispersystems.libaxolotl.state.IdentityKeyStore;
import org.whispersystems.libaxolotl.state.PreKeyBundle;
import org.whispersystems.libaxolotl.state.PreKeyStore;
import org.whispersystems.libaxolotl.state.SessionRecord;
import org.whispersystems.libaxolotl.state.SessionState;
import org.whispersystems.libaxolotl.state.SessionStore;
import org.whispersystems.libaxolotl.state.SignedPreKeyStore;
import org.whispersystems.libaxolotl.util.KeyHelper;
import org.whispersystems.libaxolotl.util.Medium;
import org.whispersystems.libaxolotl.util.guava.Optional;

public class SessionBuilder {
    private static final String TAG = "SessionBuilder";
    private final SecureRandomProvider secureRandomProvider;
    private final SessionStore sessionStore;
    private final PreKeyStore preKeyStore;
    private final SignedPreKeyStore signedPreKeyStore;
    private final IdentityKeyStore identityKeyStore;
    private final AxolotlAddress remoteAddress;

    public SessionBuilder(SecureRandomProvider secureRandomProvider, SessionStore sessionStore, PreKeyStore preKeyStore, SignedPreKeyStore signedPreKeyStore, IdentityKeyStore identityKeyStore, AxolotlAddress remoteAddress) {
        this.secureRandomProvider = secureRandomProvider;
        this.sessionStore = sessionStore;
        this.preKeyStore = preKeyStore;
        this.signedPreKeyStore = signedPreKeyStore;
        this.identityKeyStore = identityKeyStore;
        this.remoteAddress = remoteAddress;
    }

    public SessionBuilder(SecureRandomProvider secureRandomProvider, AxolotlStore store, AxolotlAddress remoteAddress) {
        this(secureRandomProvider, store, store, store, store, remoteAddress);
    }

    Optional process(SessionRecord sessionRecord, PreKeyWhisperMessage message) throws InvalidKeyIdException, InvalidKeyException, UntrustedIdentityException {
        Optional unsignedPreKeyId;
        int messageVersion = message.getMessageVersion();
        IdentityKey theirIdentityKey = message.getIdentityKey();
        if (!this.identityKeyStore.isTrustedIdentity(this.remoteAddress.getName(), theirIdentityKey)) {
            throw new UntrustedIdentityException();
        }
        switch (messageVersion) {
            case 2: {
                unsignedPreKeyId = this.processV2(sessionRecord, message);
                break;
            }
            case 3: {
                unsignedPreKeyId = this.processV3(sessionRecord, message);
                break;
            }
            default: {
                throw new AssertionError("Unknown version: " + messageVersion);
            }
        }
        this.identityKeyStore.saveIdentity(this.remoteAddress.getName(), theirIdentityKey);
        return unsignedPreKeyId;
    }

    private Optional processV3(SessionRecord sessionRecord, PreKeyWhisperMessage message) throws UntrustedIdentityException, InvalidKeyIdException, InvalidKeyException {
        if (sessionRecord.hasSessionState(message.getMessageVersion(), message.getBaseKey().serialize())) {
            Log.w(TAG, "We've already setup a session for this V3 message, letting bundled message fall through...");
            return Optional.absent();
        }
        ECKeyPair ourSignedPreKey = this.signedPreKeyStore.loadSignedPreKey(message.getSignedPreKeyId()).getKeyPair();
        BobAxolotlParameters.Builder parameters = BobAxolotlParameters.newBuilder();
        parameters.setTheirBaseKey(message.getBaseKey()).setTheirIdentityKey(message.getIdentityKey()).setOurIdentityKey(this.identityKeyStore.getIdentityKeyPair()).setOurSignedPreKey(ourSignedPreKey).setOurRatchetKey(ourSignedPreKey);
        if (message.getPreKeyId().isPresent()) {
            parameters.setOurOneTimePreKey(Optional.of(this.preKeyStore.loadPreKey((Integer)message.getPreKeyId().get()).getKeyPair()));
        } else {
            parameters.setOurOneTimePreKey(Optional.absent());
        }
        if (!sessionRecord.isFresh()) {
            sessionRecord.archiveCurrentState();
        }
        RatchetingSession.initializeSession(sessionRecord.getSessionState(), message.getMessageVersion(), parameters.create());
        sessionRecord.getSessionState().setLocalRegistrationId(this.identityKeyStore.getLocalRegistrationId());
        sessionRecord.getSessionState().setRemoteRegistrationId(message.getRegistrationId());
        sessionRecord.getSessionState().setAliceBaseKey(message.getBaseKey().serialize());
        if (message.getPreKeyId().isPresent() && (Integer)message.getPreKeyId().get() != Medium.MAX_VALUE) {
            return message.getPreKeyId();
        }
        return Optional.absent();
    }

    private Optional processV2(SessionRecord sessionRecord, PreKeyWhisperMessage message) throws UntrustedIdentityException, InvalidKeyIdException, InvalidKeyException {
        if (!message.getPreKeyId().isPresent()) {
            throw new InvalidKeyIdException("V2 message requires one time prekey id!");
        }
        if (!this.preKeyStore.containsPreKey((Integer)message.getPreKeyId().get()) && this.sessionStore.containsSession(this.remoteAddress)) {
            Log.w(TAG, "We've already processed the prekey part of this V2 session, letting bundled message fall through...");
            return Optional.absent();
        }
        ECKeyPair ourPreKey = this.preKeyStore.loadPreKey((Integer)message.getPreKeyId().get()).getKeyPair();
        BobAxolotlParameters.Builder parameters = BobAxolotlParameters.newBuilder();
        parameters.setOurIdentityKey(this.identityKeyStore.getIdentityKeyPair()).setOurSignedPreKey(ourPreKey).setOurRatchetKey(ourPreKey).setOurOneTimePreKey(Optional.absent()).setTheirIdentityKey(message.getIdentityKey()).setTheirBaseKey(message.getBaseKey());
        if (!sessionRecord.isFresh()) {
            sessionRecord.archiveCurrentState();
        }
        RatchetingSession.initializeSession(sessionRecord.getSessionState(), message.getMessageVersion(), parameters.create());
        sessionRecord.getSessionState().setLocalRegistrationId(this.identityKeyStore.getLocalRegistrationId());
        sessionRecord.getSessionState().setRemoteRegistrationId(message.getRegistrationId());
        sessionRecord.getSessionState().setAliceBaseKey(message.getBaseKey().serialize());
        if ((Integer)message.getPreKeyId().get() != Medium.MAX_VALUE) {
            return message.getPreKeyId();
        }
        return Optional.absent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(PreKeyBundle preKey) throws InvalidKeyException, UntrustedIdentityException {
        Object object = SessionCipher.SESSION_LOCK;
        synchronized (object) {
            if (!this.identityKeyStore.isTrustedIdentity(this.remoteAddress.getName(), preKey.getIdentityKey())) {
                throw new UntrustedIdentityException();
            }
            if (preKey.getSignedPreKey() != null && !Curve.verifySignature(preKey.getIdentityKey().getPublicKey(), preKey.getSignedPreKey().serialize(), preKey.getSignedPreKeySignature())) {
                throw new InvalidKeyException("Invalid signature on device key!");
            }
            if (preKey.getSignedPreKey() == null && preKey.getPreKey() == null) {
                throw new InvalidKeyException("Both signed and unsigned prekeys are absent!");
            }
            boolean supportsV3 = preKey.getSignedPreKey() != null;
            SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
            ECKeyPair ourBaseKey = Curve.generateKeyPair(this.secureRandomProvider);
            ECPublicKey theirSignedPreKey = supportsV3 ? preKey.getSignedPreKey() : preKey.getPreKey();
            Optional theirOneTimePreKey = Optional.fromNullable(preKey.getPreKey());
            Optional theirOneTimePreKeyId = theirOneTimePreKey.isPresent() ? Optional.of(new Integer(preKey.getPreKeyId())) : Optional.absent();
            AliceAxolotlParameters.Builder parameters = AliceAxolotlParameters.newBuilder();
            parameters.setOurBaseKey(ourBaseKey).setOurIdentityKey(this.identityKeyStore.getIdentityKeyPair()).setTheirIdentityKey(preKey.getIdentityKey()).setTheirSignedPreKey(theirSignedPreKey).setTheirRatchetKey(theirSignedPreKey).setTheirOneTimePreKey(supportsV3 ? theirOneTimePreKey : Optional.absent());
            if (!sessionRecord.isFresh()) {
                sessionRecord.archiveCurrentState();
            }
            RatchetingSession.initializeSession(this.secureRandomProvider, sessionRecord.getSessionState(), supportsV3 ? 3 : 2, parameters.create());
            sessionRecord.getSessionState().setUnacknowledgedPreKeyMessage(theirOneTimePreKeyId, preKey.getSignedPreKeyId(), ourBaseKey.getPublicKey());
            sessionRecord.getSessionState().setLocalRegistrationId(this.identityKeyStore.getLocalRegistrationId());
            sessionRecord.getSessionState().setRemoteRegistrationId(preKey.getRegistrationId());
            sessionRecord.getSessionState().setAliceBaseKey(ourBaseKey.getPublicKey().serialize());
            this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
            this.identityKeyStore.saveIdentity(this.remoteAddress.getName(), preKey.getIdentityKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyExchangeMessage process(KeyExchangeMessage message) throws InvalidKeyException, UntrustedIdentityException, StaleKeyExchangeException {
        Object object = SessionCipher.SESSION_LOCK;
        synchronized (object) {
            if (!this.identityKeyStore.isTrustedIdentity(this.remoteAddress.getName(), message.getIdentityKey())) {
                throw new UntrustedIdentityException();
            }
            KeyExchangeMessage responseMessage = null;
            if (message.isInitiate()) {
                responseMessage = this.processInitiate(message);
            } else {
                this.processResponse(message);
            }
            return responseMessage;
        }
    }

    private KeyExchangeMessage processInitiate(KeyExchangeMessage message) throws InvalidKeyException {
        int flags = 2;
        SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
        if (message.getVersion() >= 3 && !Curve.verifySignature(message.getIdentityKey().getPublicKey(), message.getBaseKey().serialize(), message.getBaseKeySignature())) {
            throw new InvalidKeyException("Bad signature!");
        }
        SymmetricAxolotlParameters.Builder builder = SymmetricAxolotlParameters.newBuilder();
        if (!sessionRecord.getSessionState().hasPendingKeyExchange()) {
            builder.setOurIdentityKey(this.identityKeyStore.getIdentityKeyPair()).setOurBaseKey(Curve.generateKeyPair(this.secureRandomProvider)).setOurRatchetKey(Curve.generateKeyPair(this.secureRandomProvider));
        } else {
            builder.setOurIdentityKey(sessionRecord.getSessionState().getPendingKeyExchangeIdentityKey()).setOurBaseKey(sessionRecord.getSessionState().getPendingKeyExchangeBaseKey()).setOurRatchetKey(sessionRecord.getSessionState().getPendingKeyExchangeRatchetKey());
            flags |= 4;
        }
        builder.setTheirBaseKey(message.getBaseKey()).setTheirRatchetKey(message.getRatchetKey()).setTheirIdentityKey(message.getIdentityKey());
        SymmetricAxolotlParameters parameters = builder.create();
        if (!sessionRecord.isFresh()) {
            sessionRecord.archiveCurrentState();
        }
        RatchetingSession.initializeSession(this.secureRandomProvider, sessionRecord.getSessionState(), Math.min(message.getMaxVersion(), 3), parameters);
        this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
        this.identityKeyStore.saveIdentity(this.remoteAddress.getName(), message.getIdentityKey());
        byte[] baseKeySignature = Curve.calculateSignature(this.secureRandomProvider, parameters.getOurIdentityKey().getPrivateKey(), parameters.getOurBaseKey().getPublicKey().serialize());
        return new KeyExchangeMessage(sessionRecord.getSessionState().getSessionVersion(), message.getSequence(), flags, parameters.getOurBaseKey().getPublicKey(), baseKeySignature, parameters.getOurRatchetKey().getPublicKey(), parameters.getOurIdentityKey().getPublicKey());
    }

    private void processResponse(KeyExchangeMessage message) throws StaleKeyExchangeException, InvalidKeyException {
        SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
        SessionState sessionState = sessionRecord.getSessionState();
        boolean hasPendingKeyExchange = sessionState.hasPendingKeyExchange();
        boolean isSimultaneousInitiateResponse = message.isResponseForSimultaneousInitiate();
        if (!hasPendingKeyExchange || sessionState.getPendingKeyExchangeSequence() != message.getSequence()) {
            Log.w(TAG, "No matching sequence for response. Is simultaneous initiate response: " + isSimultaneousInitiateResponse);
            if (!isSimultaneousInitiateResponse) {
                throw new StaleKeyExchangeException();
            }
            return;
        }
        SymmetricAxolotlParameters.Builder parameters = SymmetricAxolotlParameters.newBuilder();
        parameters.setOurBaseKey(sessionRecord.getSessionState().getPendingKeyExchangeBaseKey()).setOurRatchetKey(sessionRecord.getSessionState().getPendingKeyExchangeRatchetKey()).setOurIdentityKey(sessionRecord.getSessionState().getPendingKeyExchangeIdentityKey()).setTheirBaseKey(message.getBaseKey()).setTheirRatchetKey(message.getRatchetKey()).setTheirIdentityKey(message.getIdentityKey());
        if (!sessionRecord.isFresh()) {
            sessionRecord.archiveCurrentState();
        }
        RatchetingSession.initializeSession(this.secureRandomProvider, sessionRecord.getSessionState(), Math.min(message.getMaxVersion(), 3), parameters.create());
        if (sessionRecord.getSessionState().getSessionVersion() >= 3 && !Curve.verifySignature(message.getIdentityKey().getPublicKey(), message.getBaseKey().serialize(), message.getBaseKeySignature())) {
            throw new InvalidKeyException("Base key signature doesn't match!");
        }
        this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
        this.identityKeyStore.saveIdentity(this.remoteAddress.getName(), message.getIdentityKey());
    }

    public KeyExchangeMessage process() {
        Object object = SessionCipher.SESSION_LOCK;
        synchronized (object) {
            try {
                int sequence = KeyHelper.getRandomSequence(this.secureRandomProvider, 65534) + 1;
                int flags = 1;
                ECKeyPair baseKey = Curve.generateKeyPair(this.secureRandomProvider);
                ECKeyPair ratchetKey = Curve.generateKeyPair(this.secureRandomProvider);
                IdentityKeyPair identityKey = this.identityKeyStore.getIdentityKeyPair();
                byte[] baseKeySignature = Curve.calculateSignature(this.secureRandomProvider, identityKey.getPrivateKey(), baseKey.getPublicKey().serialize());
                SessionRecord sessionRecord = this.sessionStore.loadSession(this.remoteAddress);
                sessionRecord.getSessionState().setPendingKeyExchange(sequence, baseKey, ratchetKey, identityKey);
                this.sessionStore.storeSession(this.remoteAddress, sessionRecord);
                return new KeyExchangeMessage(2, sequence, flags, baseKey.getPublicKey(), baseKeySignature, ratchetKey.getPublicKey(), identityKey.getPublicKey());
            }
            catch (InvalidKeyException e) {
                throw new AssertionError(e);
            }
        }
    }
}

