/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.libaxolotl;

import org.whispersystems.libaxolotl.IdentityKey;
import org.whispersystems.libaxolotl.InvalidKeyException;
import org.whispersystems.libaxolotl.ecc.Curve;
import org.whispersystems.libaxolotl.ecc.ECPrivateKey;
import org.whispersystems.libaxolotl.state.protos.IdentityKeyPairStructure;

public class IdentityKeyPair {
    private final IdentityKey publicKey;
    private final ECPrivateKey privateKey;

    public IdentityKeyPair(IdentityKey publicKey, ECPrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public IdentityKeyPair(byte[] serialized) throws InvalidKeyException {
        IdentityKeyPairStructure structure = IdentityKeyPairStructure.fromBytes(serialized);
        this.publicKey = new IdentityKey(structure.getPublickey(), 0);
        this.privateKey = Curve.decodePrivatePoint(structure.getPrivatekey());
    }

    public IdentityKey getPublicKey() {
        return this.publicKey;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public byte[] serialize() {
        IdentityKeyPairStructure structure = new IdentityKeyPairStructure();
        structure.setPublickey(this.publicKey.serialize());
        structure.setPrivatekey(this.privateKey.serialize());
        return structure.toBytes();
    }
}

