/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.rawclasspath.providers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;

public class RawClasspathProvider
implements ConfigurationProvider {
    private String classpath;
    private Configuration configuration;

    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    public void load() throws ConfigurationException {
        if (this.configuration != null && this.classpath != null) {
            String[] paths = this.classpath.split(";");
            URL[] urlArray = new URL[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                try {
                    File file = new File(paths[i]);
                    urlArray[i] = file.toURI().toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Invalid path: " + paths[i], (Throwable)e);
                }
            }
            URLClassLoader cl = new URLClassLoader(urlArray);
            this.configuration.getParameters().put("classLoader", cl);
        }
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }
}

