/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.rawclasspath.providers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;

public class RawClasspathProvider
implements ConfigurationProvider {
    private String classpath;
    private Configuration configuration;

    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    public void load() throws ConfigurationException {
        if (this.configuration != null && this.classpath != null) {
            String[] paths = this.classpath.split(";");
            String[] bootPath = System.getProperties().get("sun.boot.class.path").toString().split(Character.toString(File.pathSeparatorChar));
            URL[] urlArray = new URL[paths.length + bootPath.length];
            int i = 0;
            for (String lib : bootPath) {
                try {
                    urlArray[i] = new File(lib).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Invalid URL for the boot classpath entry " + lib, e.getCause());
                }
                ++i;
            }
            for (String path : paths) {
                try {
                    File file = new File(path);
                    urlArray[i] = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Invalid path: " + paths[i], (Throwable)e);
                }
                ++i;
            }
            URLClassLoader cl = new URLClassLoader(urlArray){

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    Class<?> result = null;
                    try {
                        result = this.findClass(name);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (result != null) {
                        return result;
                    }
                    return super.loadClass(name, resolve);
                }

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return this.loadClass(name, false);
                }
            };
            this.configuration.getParameters().put("classLoader", cl);
        }
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }
}

