/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.visitors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.visitors.CloneVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.pmd.visitors.Addition;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;
import org.walkmod.pmd.visitors.Removal;
import org.walkmod.walkers.VisitorContext;

@RequiresSemanticAnalysis(optional=true)
public class PMDVisitor
extends VoidVisitorAdapter<VisitorContext> {
    private String configurationfile = "java-basic, java-empty, java-imports, java-unnecessary, java-unusedcode";
    private RuleSet rules = null;
    private List<Rule> fixingRules = new LinkedList<Rule>();
    private List<PMDRuleVisitor> visitors = null;
    private boolean splitExecution = false;

    private void parseCfg(String config) throws Exception {
        String[] parts;
        RuleSetFactory factory = new RuleSetFactory();
        for (String part : parts = config.split(",")) {
            RuleSet aux = factory.createRuleSet(part.trim());
            if (this.rules == null) {
                this.rules = aux;
                continue;
            }
            this.rules.addRuleSet(aux);
        }
    }

    protected String getRuleSetParts(Rule rule) {
        String url = rule.getExternalInfoUrl();
        String[] parts = url.split("#");
        int index = parts[0].lastIndexOf("/");
        String package_ = parts[0].substring(index + 1, parts[0].length() - ".html".length());
        String name = parts[1];
        return package_ + ":" + name;
    }

    public void visit(CompilationUnit cu, VisitorContext ctx) {
        if (this.rules == null) {
            try {
                this.setConfigurationFile(this.configurationfile);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.rules != null) {
            if (this.visitors == null) {
                this.visitors = new LinkedList<PMDRuleVisitor>();
                LinkedList<PMDRuleVisitor> additionVisitors = new LinkedList<PMDRuleVisitor>();
                LinkedList<PMDRuleVisitor> modificationVisitors = new LinkedList<PMDRuleVisitor>();
                LinkedList<PMDRuleVisitor> removalVisitors = new LinkedList<PMDRuleVisitor>();
                LinkedList<Rule> additionRules = new LinkedList<Rule>();
                LinkedList<Rule> modificationRules = new LinkedList<Rule>();
                LinkedList<Rule> removalRules = new LinkedList<Rule>();
                for (Rule rule : this.rules.getRules()) {
                    Object o = null;
                    if (!rule.getLanguage().getName().toLowerCase().equals("java")) continue;
                    try {
                        String[] parts = this.getRuleSetParts(rule).split(":");
                        Class<?> c = Class.forName("org.walkmod.pmd.ruleset.java." + parts[0] + ".visitors." + parts[1], true, ctx.getClassLoader());
                        o = c.newInstance();
                        if (c.isAnnotationPresent(Modification.class)) {
                            modificationVisitors.add(o);
                            modificationRules.add(rule);
                            continue;
                        }
                        if (c.isAnnotationPresent(Removal.class)) {
                            removalVisitors.add(o);
                            removalRules.add(rule);
                            continue;
                        }
                        if (!c.isAnnotationPresent(Addition.class)) continue;
                        additionVisitors.add(o);
                        additionRules.add(rule);
                    }
                    catch (Exception exception) {}
                }
                this.visitors.addAll(removalVisitors);
                this.fixingRules.addAll(removalRules);
                this.visitors.addAll(modificationVisitors);
                this.fixingRules.addAll(modificationRules);
                this.visitors.addAll(additionVisitors);
                this.fixingRules.addAll(additionRules);
            }
            Iterator<Rule> it = this.fixingRules.iterator();
            for (PMDRuleVisitor visitor : this.visitors) {
                if (this.splitExecution) {
                    boolean requiresSemanticAnalysis = visitor.getClass().isAnnotationPresent(RequiresSemanticAnalysis.class);
                    CompilationUnit aux = null;
                    if (cu.withSymbols() || !requiresSemanticAnalysis) {
                        aux = (CompilationUnit)new CloneVisitor().visit(cu, (Object)ctx);
                        visitor.visit(cu, (Node)aux);
                        ctx.addResultNode((Object)aux);
                    }
                    if (!it.hasNext()) continue;
                    Rule rule = it.next();
                    if (aux == null) continue;
                    HashMap<String, String> data = new HashMap<String, String>();
                    String[] ruleId = this.getRuleSetParts(rule).split(":");
                    data.put("cause", "pmd.java." + ruleId[0] + "." + ruleId[1]);
                    aux.setData(data);
                    continue;
                }
                visitor.visit(cu, null);
            }
        }
    }

    public RuleSet getRules() {
        return this.rules;
    }

    public void setConfigurationFile(String configurationFile) throws Exception {
        this.configurationfile = configurationFile;
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.parseCfg(this.configurationfile);
        Thread.currentThread().setContextClassLoader(cloader);
    }

    public void setVisitors(List<PMDRuleVisitor> list) {
        this.visitors = list;
    }

    public void setSplitExecution(boolean splitExecution) {
        this.splitExecution = splitExecution;
    }
}

