/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.optimizations.visitors;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.BooleanLiteralExpr;
import org.walkmod.javalang.ast.expr.DoubleLiteralExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.IntegerLiteralExpr;
import org.walkmod.javalang.ast.expr.LongLiteralExpr;
import org.walkmod.javalang.ast.expr.NullLiteralExpr;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@Modification
public class RedundantFieldInitializer
extends PMDRuleVisitor {
    @Override
    public void visit(FieldDeclaration n, Node node) {
        FieldDeclaration aux = (FieldDeclaration)node;
        List vds = aux.getVariables();
        if (vds != null && vds.size() == 1) {
            BooleanLiteralExpr lle;
            VariableDeclarator vd = (VariableDeclarator)vds.get(0);
            Expression expr = vd.getInit();
            if (expr instanceof NullLiteralExpr) {
                this.modifyVar(vds, vd);
            } else if (expr instanceof IntegerLiteralExpr) {
                IntegerLiteralExpr iexpr = (IntegerLiteralExpr)expr;
                if ("0".equals(iexpr.getValue())) {
                    this.modifyVar(vds, vd);
                }
            } else if (expr instanceof LongLiteralExpr) {
                LongLiteralExpr lle2 = (LongLiteralExpr)expr;
                if ("0L".equals(lle2.getValue())) {
                    this.modifyVar(vds, vd);
                }
            } else if (expr instanceof DoubleLiteralExpr) {
                DoubleLiteralExpr lle3 = (DoubleLiteralExpr)expr;
                if ("0d".equals(lle3.getValue())) {
                    this.modifyVar(vds, vd);
                }
            } else if (expr instanceof BooleanLiteralExpr && !(lle = (BooleanLiteralExpr)expr).getValue()) {
                this.modifyVar(vds, vd);
            }
        }
    }

    private void modifyVar(List<VariableDeclarator> vds, VariableDeclarator vd) {
        vds.clear();
        try {
            vd = vd.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        vd.setInit(null);
        vds.add(vd);
    }
}

