/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.controversial.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.ConstructorDeclaration;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.pmd.visitors.Addition;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@Addition
public class AtLeastOneConstructor
extends PMDRuleVisitor {
    @Override
    public void visit(ClassOrInterfaceDeclaration n, Node ctx) {
        super.visit(n, ctx);
        ClassOrInterfaceDeclaration aux = (ClassOrInterfaceDeclaration)ctx;
        if (!n.isInterface()) {
            LinkedList<ConstructorDeclaration> members = aux.getMembers();
            if (members != null) {
                Iterator it = members.iterator();
                boolean hasConstructor = false;
                while (it.hasNext() && !hasConstructor) {
                    BodyDeclaration next = (BodyDeclaration)it.next();
                    hasConstructor = next instanceof ConstructorDeclaration;
                }
                if (!hasConstructor) {
                    ConstructorDeclaration cd = new ConstructorDeclaration(1, n.getName());
                    cd.setBlock(new BlockStmt(new LinkedList()));
                    members.add(0, cd);
                }
            } else {
                members = new LinkedList<ConstructorDeclaration>();
                ConstructorDeclaration cd = new ConstructorDeclaration(1, n.getName());
                cd.setBlock(new BlockStmt(new LinkedList()));
                members.add(0, cd);
                aux.setMembers(members);
            }
        }
    }
}

